﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ct.Asteroid
{
    class Schiff
    {
        public int x = 0, y = 0;                                            // aktuelle Position
        public int x1 = 0, y1 = 0;                                          // alte Position
        public int dx = 0, dy = 0;                                          // Bewegungsrichtung

        public int dx1 = 0, dx2 = 0, dx3 = 0, dx4 = 0;                      // Teilbewegungen in x Richtung merken(8 Zyklen)
        public int dx5 = 0, dx6 = 0, dx7 = 0, dx8 = 0;

        public int dy1 = 0, dy2 = 0, dy3 = 0, dy4 = 0;                      // Teilbewegungen in y Richtung merken(8 Zyklen)
        public int dy5 = 0, dy6 = 0, dy7 = 0, dy8 = 0;

        public int Werte = -1;                                              // Höchste Genaugkeit wird bei 8 Teilbewegungen erreicht

        public void calc(int pos_x, int pos_y)
        {
            x = pos_x;
            y = pos_y;

            if (y == 0)                                                     // LEER -> RESET (0 keine gültige Position)
            {
                x = 0; y = 0; x1 = 0; y1 = 0; Werte = -1;
                dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
                return;
            }

            if (y1 == 0) { x1 = x; y1 = y; Werte = -1; }                    // keine alten Position vorhanden, aktuelle Position für alte Position übernehmen

            dx = x - x1;                                                // Bewegung ermitteln
            dy = y - y1;

            x1 = x; y1 = y;                                                 // aktuelle Position als alte Position übernehmen

            if (dx < -512) dx = dx + 1024;                                  // Überlauf bereinigen
            if (dx > 512) dx = dx - 1024;                                   // Überlauf bereinigen
            if (dy < -512) dy = dy + 768;                                   // Überlauf bereinigen
            if (dy > 512) dy = dy - 768;                                    // Überlauf bereinigen

            if ((dx <= 8) && (dx >= -8) && (dy <= 8) && (dy >= -8))         // gültiger dx und dy Wert -> AKTUALISIEREN sonst RESET
            {
                dx8 = dx7; dy8 = dy7;                                       // alte Bewegungen merken
                dx7 = dx6; dy7 = dy6;                                       // alte Bewegungen merken
                dx6 = dx5; dy6 = dy5;                                       // alte Bewegungen merken
                dx5 = dx4; dy5 = dy4;                                       // alte Bewegungen merken
                dx4 = dx3; dy4 = dy3;                                       // alte Bewegungen merken
                dx3 = dx2; dy3 = dy2;                                       // alte Bewegungen merken
                dx2 = dx1; dy2 = dy1;                                       // alte Bewegungen merken
                dx1 = dx;                                                   // alte Bewegungen merken
                dy1 = dy;

                dx = dx1 + dx2 + dx3 + dx4 + dx5 + dx6 + dx7 + dx8;         // Einzelvektoren addieren
                dy = dy1 + dy2 + dy3 + dy4 + dy5 + dy6 + dy7 + dy8;         // Einzelvektoren´addieren
            }
            else
            {
                Werte = -1;
                dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
            }

            if (Werte < 8) Werte = Werte + 1;
            if (Werte > 8) Werte = 8;

            if (Werte == 1) { dx = dx * 800; dy = dy * 800; dx = dx / 100; dy = dy / 100; }
            if (Werte == 2) { dx = dx * 400; dy = dy * 400; dx = dx / 100; dy = dy / 100; }
            if (Werte == 3) { dx = dx * 267; dy = dy * 267; dx = dx / 100; dy = dy / 100; }
            if (Werte == 4) { dx = dx * 200; dy = dy * 200; dx = dx / 100; dy = dy / 100; }
            if (Werte == 5) { dx = dx * 160; dy = dy * 160; dx = dx / 100; dy = dy / 100; }
            if (Werte == 6) { dx = dx * 133; dy = dy * 133; dx = dx / 100; dy = dy / 100; }
            if (Werte == 7) { dx = dx * 114; dy = dy * 114; dx = dx / 100; dy = dy / 100; }
        }
    }

    class UFO
    {
        public int x = 0, y = 0;                                            // aktuelle Position
        public int x1 = 0, y1 = 0;                                          // alte Position
        public int dx = 0, dy = 0;                                          // Bewegungsrichtung

        public int dx1 = 0, dx2 = 0, dx3 = 0, dx4 = 0;                      // Teilbewegungen in x Richtung merken(8 Zyklen)
        public int dx5 = 0, dx6 = 0, dx7 = 0, dx8 = 0;

        public int dy1 = 0, dy2 = 0, dy3 = 0, dy4 = 0;                      // Teilbewegungen in y Richtung merken(8 Zyklen)
        public int dy5 = 0, dy6 = 0, dy7 = 0, dy8 = 0;

        public int Werte = -1;                                              // Höchste Genaugkeit wird bei 8 Teilbewegungen erreicht

        public int dist = 1000000;                                          // quadratischer Abstand
        public int Abstand = 1000;                                          // Abstand
        public int AbstandH = 1000;                                         // Abstand beim nächsten Zyklus -> Abfrage ob Hypersprung notwendig

        public int AbstandMM = 1000;                                        // Abstand von Mittelpunkt Asteroid bis Mittelpunkt Schiff
        public int r = 0;                                                   // quadratischer Radius
        public int Radius = 0;                                              // Radius 
        public int RadiusS= 0;                                              // Radius für Schusswinkeltoleranzermittlung 

        public int ZDrehung = 0;                                            // Zyklen bis Schiff in Schussposition
        public int ZSumme = 0;                                                // Zyklen bis Schiff in Schussposition + Zyklen bis Schuss auftrifft
        public bool ForceLinks = false;                                     // Links Drehung erzwingen            
        public bool ForceRechts = false;                                    // Rechts Drehung erzwingen

        public int danger = 9999;                                           // Gefährlichkeit (Abstand, Zyklen)

        public int Schuss = -1;                                             // Zähler für Schuss ... bei 0 Aufschlag ... bei -1 wurde noch kein Schuss auf Asteroid abgegeben
        public double AbweichungW=0;                                        // Schusswinkelabweichung (aktuelle Schiffsausrichtung)
        public int AbweichungZ=0;                                        // Zyklen bis zum Auftreffen eines Schusses (aktuelle Schiffsposition)

        public int diff_x = 0, diff_y = 0;

        public void calc(int saucer_x, int saucer_y,int saucer_size, int ship_x, int ship_y, double Latenz)
        {
            if (Schuss >= 0) Schuss = Schuss - 1;

            x = saucer_x;
            y = saucer_y;

            if (y == 0)                                                     // LEER -> RESET (0 keine gültige Position)
            {
                x = 0; y = 0; x1 = 0; y1 = 0; Werte = -1;
                dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
                ZDrehung = 0; ZSumme = 0; danger = 9999;
                Schuss = -1;
                return;
            }

            if (y1 == 0) { x1 = x; y1 = y; Werte = -1; }                    // keine alten Position vorhanden, aktuelle Position für alte Position übernehmen

            dx = x - x1;                                                    // Bewegung ermitteln
            dy = y - y1;

            x1 = x; y1 = y;                                                 // aktuelle Position als alte Position übernehmen

            if (dx < -512) dx = dx + 1024;                                  // Überlauf bereinigen
            if (dx > 512) dx = dx - 1024;                                   // Überlauf bereinigen
            if (dy < -512) dy = dy + 768;                                   // Überlauf bereinigen
            if (dy > 512) dy = dy - 768;                                    // Überlauf bereinigen

            if ((dx <= 8) && (dx >= -8) && (dy <= 8) && (dy >= -8))         // gültiger dx und dy Wert -> AKTUALISIEREN sonst RESET
            {
                dx8 = dx7; dy8 = dy7;                                       // alte Bewegungen merken
                dx7 = dx6; dy7 = dy6;                                       // alte Bewegungen merken
                dx6 = dx5; dy6 = dy5;                                       // alte Bewegungen merken
                dx5 = dx4; dy5 = dy4;                                       // alte Bewegungen merken
                dx4 = dx3; dy4 = dy3;                                       // alte Bewegungen merken
                dx3 = dx2; dy3 = dy2;                                       // alte Bewegungen merken
                dx2 = dx1; dy2 = dy1;                                       // alte Bewegungen merken
                dx1 = dx;                                                   // alte Bewegungen merken
                dy1 = dy;

                dx = dx1 + dx2 + dx3 + dx4 + dx5 + dx6 + dx7 + dx8;         // Einzelvektoren addieren
                dy = dy1 + dy2 + dy3 + dy4 + dy5 + dy6 + dy7 + dy8;         // Einzelvektoren´addieren
            }
            else
            {
                Werte = -1;
                dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
            }

            if (Werte < 8) Werte = Werte + 1;
            if (Werte > 8) Werte = 8;

            if (Werte == 1) { dx = dx * 800; dy = dy * 800; dx = dx / 100; dy = dy / 100; }
            if (Werte == 2) { dx = dx * 400; dy = dy * 400; dx = dx / 100; dy = dy / 100; }
            if (Werte == 3) { dx = dx * 267; dy = dy * 267; dx = dx / 100; dy = dy / 100; }
            if (Werte == 4) { dx = dx * 200; dy = dy * 200; dx = dx / 100; dy = dy / 100; }
            if (Werte == 5) { dx = dx * 160; dy = dy * 160; dx = dx / 100; dy = dy / 100; }
            if (Werte == 6) { dx = dx * 133; dy = dy * 133; dx = dx / 100; dy = dy / 100; }
            if (Werte == 7) { dx = dx * 114; dy = dy * 114; dx = dx / 100; dy = dy / 100; }

            // -------------------------- Diverses ---------------------------- //

            diff_x = ship_x - x; diff_y = ship_y - y;       // MinAbstand zum Schiff

            while (diff_x < -512) diff_x += 1024;           // diff_x normalisieren auf -512 ... 511
            while (diff_x > 511) diff_x -= 1024;

            while (diff_y < -384) diff_y += 768;            // dy normalisieren auf -384 ... 383
            while (diff_y > 383) diff_y -= 768;

            dist = diff_x * diff_x + diff_y * diff_y;       // MinAbstand zum Quadrat
            AbstandMM = (int)Math.Sqrt(diff_x * diff_x + diff_y * diff_y);
            AbstandH = (int)(Math.Sqrt(((Double)diff_x - (Double)dx / 4.0 - (Double)dx / 8.0 * Latenz) * ((Double)diff_x - (Double)dx / 4.0 - (Double)dx / 8.0 * Latenz) + ((Double)diff_y - (Double)dy / 4.0 - (Double)dy / 8.0 * Latenz) * ((Double)diff_y - (Double)dy / 4.0 - (Double)dy / 8.0 * Latenz)));

            switch (saucer_size)
            {	// Abstand um den ungefähren Radius des UFOs korrigieren
                case 15: RadiusS = 15; Radius = 20; r = 20 * 12; dist -= r; Abstand = AbstandMM - 20 - 18; AbstandH = AbstandH - 20 - 18; break;   // großes UFO
                case 14: RadiusS = 10; Radius = 10; r = 10 *  6; dist -= r; Abstand = AbstandMM - 10 - 18; AbstandH = AbstandH - 20 - 18; break;   // kleines UFO
            }

            if (AbstandH < 0) AbstandH = 0;
            if (Abstand < 0) Abstand = 0;

        }
    }

    class Asteroid
    {
        public int x = 0, y = 0;                                            // aktuelle Position
        public int x1 = 0, y1 = 0;                                          // alte Position
        public int dx = 0, dy=0;                                            // Bewegungsrichtung

        public int dx1 = 0, dx2 = 0, dx3 = 0, dx4 = 0;                      // Teilbewegungen in x Richtung merken(8 Zyklen)
        public int dx5 = 0, dx6 = 0, dx7 = 0, dx8 = 0;  

        public int dy1 = 0, dy2 = 0, dy3 = 0, dy4 = 0;                      // Teilbewegungen in y Richtung merken(8 Zyklen)
        public int dy5 = 0, dy6 = 0, dy7 = 0, dy8 = 0; 

        public int Werte = -1;                                              // Höchste Genaugkeit wird bei 8 Teilbewegungen erreicht

        public int type;                                                    // 1 ... 4, äußere Form
        public int sf;                                                      // scale factor: 0 = groß, 15 = mittel, 14 = klein
        public int sf1;                                                     // old scale factor: 0 = groß, 15 = mittel, 14 = klein

        public int diff_x=0, diff_y=0;                                      // Positionsdifferenz Asteroid - Schiff
       
        public double Grad_Position = 0;                                    // Grad Position Asteroid gegenüber Schiff
        public double Grad_Bewegung = 0;                                    // Grad Bewegung Asteroid
        public double Grad_Differenz = 0;                                   // Grad Differenz

        public int dist = 1000000;                                          // quadratischer Abstand
        public int Abstand = 1000;                                          // Abstand
        public int AbstandH = 1000;                                         // Abstand beim nächsten Zyklus -> Abfrage ob Hypersprung notwendig
        public int AbstandMM = 1000;                                        // Abstand von Mittelpunkt Asteroid bis Mittelpunkt Schiff
        public int MinAbstand = 1000;                                       // kleinster Abstand (0=Kollision)
        public int Zyklen = 1000;                                           // Zyklen bis zum kleinsten Abstand

        public int ZDrehung = 0;                                            // Zyklen bis Schiff in Schussposition
        public int ZEntfernung = 0;                                         // Zyklen bis Schuss auftrifft
        public int ZSumme=0;                                                // Zyklen bis Schiff in Schussposition + Zyklen bis Schuss auftrifft
        public bool ForceLinks = false;                                     // Links Drehung erzwingen            
        public bool ForceRechts = false;                                    // Rechts Drehung erzwingen
        public bool ForceHold = false;                                      // Warten erzwingen

        public int danger = 9999;                                           // Gefährlichkeit (Abstand, Zyklen)
        public int r = 0;                                                   // quadratischer Radius

        public int Radius = 0;                                              // Radius        
        public int RadiusS = 0;                                             // Radius für Schusswinkeltoleranzermittlung
        public int RadiusK = 0;                                             // Radius für Trefferermittlung

        public int Schuss1 = -1;                                            // Zähler für Schuss ... bei 0 Aufschlag ... bei -1 wurde noch kein Schuss auf Asteroid abgegeben
        public int Schuss2 = -1;                                            // Zähler für Schuss ... bei 0 Aufschlag ... bei -1 wurde noch kein Schuss auf Asteroid abgegeben
        public int Schuss3 = -1;                                            // Zähler für Schuss ... bei 0 Aufschlag ... bei -1 wurde noch kein Schuss auf Asteroid abgegeben
        public int Schuss4 = -1;                                            // Zähler für Schuss ... bei 0 Aufschlag ... bei -1 wurde noch kein Schuss auf Asteroid abgegeben

        public int Ziel_Lock = 0;                                           // Zähler für Ziel Beibehaltung (>0 Ziel wird nicht verändert)
        public double AbweichungW=0;                                        // Schusswinkelabweichung (aktuelle Schiffsausrichtung)
        public int AbweichungZ=0;                                           // Zyklen bis zum Auftreffen eines Schusses (aktuelle Schiffsposition)

        public int ok = 0;                                                  // Positionsberechnung richtig (5 = 100% ige Übereinstimmung)
        public int oldpos = -1;                                             // alte Position für Umsortierung merken

        public void cls()
        {
            x = 0; y = 0; type = 0; sf = 0;
        }

        public void set(int x, int y, int type, int sf)
        {
            this.x = x; this.y = y; this.type = type; this.sf = sf;
        }

        public void calc(int ship_x, int ship_y, double Latenz)
        {
            if (Schuss1 >= 0) Schuss1 = Schuss1 - 1;
            if (Schuss2 >= 0) Schuss2 = Schuss2 - 1;
            if (Schuss3 >= 0) Schuss3 = Schuss3 - 1;
            if (Schuss4 >= 0) Schuss4 = Schuss4 - 1;
            if (Ziel_Lock > 0) Ziel_Lock = Ziel_Lock - 1;

            if (y == 0)                                                     // LEER -> RESET (0 keine gültige Position)
            {
                x = 0; y = 0; x1 = 0; y1 = 0; Werte = -1; ok = 0;
                this.dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                this.dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
                Grad_Bewegung = 0; Grad_Differenz = 0; Grad_Position = 0; MinAbstand = 1000; Abstand = 1000; AbstandH = 1000; AbstandMM = 1000; Zyklen = 1000; danger = 9999;
                Schuss1 = -1; Schuss2 = -1; Schuss3 = -1; Schuss4 = -1; Ziel_Lock = 0;
                ZDrehung = 0; ZEntfernung = 0; ZSumme = 0;
                return;
            }

            if (y1 == 0) { x1 = x; y1 = y; Werte = -1; }                    // keine alten Werte vorhanden, aktuellen Wert für alten Werte übernehmen

            dx = x - x1;                                                    // Bewegung ermitteln
            dy = y - y1;

            x1 = x; y1 = y; sf1 = sf;                                       // aktuelle Position als alte Position übernehmen

            if (dx < -512) dx = dx + 1024;                                  // Überlauf bereinigen
            if (dx > 512) dx = dx - 1024;                                   // Überlauf bereinigen
            if (dy < -512) dy = dy + 768;                                   // Überlauf bereinigen
            if (dy > 512) dy = dy - 768;                                    // Überlauf bereinigen

            if ((dx <= 8) && (dx >= -8) && (dy <= 8) && (dy >= -8))         // gültiger dx und dy Wert -> AKTUALISIEREN sonst RESET
            {
                dx8 = dx7; dy8 = dy7;                                       // alte Bewegungen merken
                dx7 = dx6; dy7 = dy6;                                       // alte Bewegungen merken
                dx6 = dx5; dy6 = dy5;                                       // alte Bewegungen merken
                dx5 = dx4; dy5 = dy4;                                       // alte Bewegungen merken
                dx4 = dx3; dy4 = dy3;                                       // alte Bewegungen merken
                dx3 = dx2; dy3 = dy2;                                       // alte Bewegungen merken
                dx2 = dx1; dy2 = dy1;                                       // alte Bewegungen merken
                dx1 = dx;                                                   // alte Bewegungen merken
                dy1 = dy;
                

                dx = dx1 + dx2 + dx3 + dx4 + dx5 + dx6 + dx7 + dx8;         // Einzelvektoren addieren
                dy = dy1 + dy2 + dy3 + dy4 + dy5 + dy6 + dy7 + dy8;         // Einzelvektoren´addieren
            }
            else
            {
                Werte = -1; Schuss1 = -1; Schuss2 = -1; Schuss3 = -1; Schuss4 = -1; Ziel_Lock = 0;
                dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
            }

            if (Werte < 8) Werte = Werte + 1;
            if (Werte > 8) Werte = 8;

            if (Werte == 1) { dx = dx * 800; dy = dy * 800; dx = dx / 100; dy = dy / 100; }
            if (Werte == 2) { dx = dx * 400; dy = dy * 400; dx = dx / 100; dy = dy / 100; }
            if (Werte == 3) { dx = dx * 267; dy = dy * 267; dx = dx / 100; dy = dy / 100; }
            if (Werte == 4) { dx = dx * 200; dy = dy * 200; dx = dx / 100; dy = dy / 100; }
            if (Werte == 5) { dx = dx * 160; dy = dy * 160; dx = dx / 100; dy = dy / 100; }
            if (Werte == 6) { dx = dx * 133; dy = dy * 133; dx = dx / 100; dy = dy / 100; }
            if (Werte == 7) { dx = dx * 114; dy = dy * 114; dx = dx / 100; dy = dy / 100; }

            // -------------------------- Winkelberechnungen ---------------------------- //

            diff_x = ship_x - x; diff_y = ship_y - y;       // Abstand zum Schiff

            while (diff_x < -512) diff_x += 1024;           // diff_x normalisieren auf -512 ... 511
            while (diff_x > 511) diff_x -= 1024;

            while (diff_y < -384) diff_y += 768;            // dy normalisieren auf -384 ... 383
            while (diff_y > 383) diff_y -= 768;

            dist = diff_x * diff_x + diff_y * diff_y;       // MinAbstand zum Quadrat

            switch (sf) // MinAbstand um den ungefähren Radius des Asteroiden korrigieren
            {
                case 0: RadiusS = 20; RadiusK = 30;  Radius = 40; r = Radius * Radius; dist -= r; break;    // großer Asteroid
                case 15: RadiusS = 15; RadiusK = 20;  Radius = 20; r = Radius * Radius; dist -= r; break;    // mittlerer Asteroid
                case 14: RadiusS = 11; RadiusK = 13;  Radius = 8; r = Radius * Radius; dist -= r; break;    // kleiner Asteroid
            }

            if ((diff_x == 0 && diff_y == 0) || (dx == 0 && dy == 0))
            {
                Grad_Differenz = 180; MinAbstand = 1000; Zyklen = 1000; danger = 9999; Abstand = 1000; AbstandH = 1000; AbstandMM = 1000; 
            }
            else
            {
                if (diff_x >= 0) Grad_Position = (Math.Atan2((double)-diff_y, (double)diff_x) * 180.0 / Math.PI) + 90.0;
                if (diff_x < 0) Grad_Position = (Math.Atan2((double)diff_y, (double)-diff_x) * 180.0 / Math.PI) + 270.0;

                if (dx >= 0) Grad_Bewegung = (Math.Atan2((double)-dy, (double)dx) * 180.0 / Math.PI) + 90.0;
                if (dx < 0) Grad_Bewegung = (Math.Atan2((double)dy, (double)-dx) * 180.0 / Math.PI) + 270.0;

                Grad_Differenz = Grad_Position - Grad_Bewegung;
                if (Grad_Differenz > 180) Grad_Differenz = Grad_Differenz - 360;
                if (Grad_Differenz < -180) Grad_Differenz = Grad_Differenz + 360;

                if (Math.Abs(Grad_Differenz) < 90) // bewegt sich auf das Schiff zu 
                {
                    MinAbstand = (int)Math.Abs(Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y)) * Math.Sin(Grad_Differenz / 180.0 * Math.PI));
                }
                else MinAbstand = 1000; // bewegt sich vom Schiff weg oder bleibt gleich

                AbstandMM = (int)Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y));
                // AbstandH = (int)(Math.Sqrt(((Double)diff_x - (Double)dx / 4.0) * ((Double)diff_x - (Double)dx / 4.0) + ((Double)diff_y - (Double)dy / 4.0) * ((Double)diff_y - (Double)dy / 4.0)));
                AbstandH = (int)(Math.Sqrt(((Double)diff_x - (Double)dx / 4.0-(Double)dx/8.0*Latenz) * ((Double)diff_x - (Double)dx / 4.0-(Double)dx/8.0*Latenz) + ((Double)diff_y - (Double)dy / 4.0 -(Double)dy/8.0*Latenz) * ((Double)diff_y - (Double)dy / 4.0-(Double)dy/8.0*Latenz)));

                if (sf == 0)  { MinAbstand = MinAbstand - 44; Abstand = AbstandMM - 44; AbstandH = AbstandH - 44; }  // 41 ... 44
                if (sf == 15) { MinAbstand = MinAbstand - 26; Abstand = AbstandMM - 26; AbstandH = AbstandH - 26; }  // 25 ... 26
                if (sf == 14) { MinAbstand = MinAbstand - 19; Abstand = AbstandMM - 19; AbstandH = AbstandH - 19; }  // 18 ... 19

                if (AbstandH < 0) AbstandH = 0;
                if (Abstand < 0) Abstand = 0;
                if (MinAbstand < 0) MinAbstand = 0;
                if (MinAbstand > 9999) MinAbstand = 9999;

                if (sf == 0) Zyklen = (int)(Math.Abs(Math.Sqrt(diff_x * diff_x + diff_y * diff_y - 44*44) * Math.Cos(Grad_Differenz / 180 * Math.PI) * 8.0) / (Math.Sqrt(dx * dx + dy * dy)));
                if (sf == 15) Zyklen = (int)(Math.Abs(Math.Sqrt(diff_x * diff_x + diff_y * diff_y - 26*26) * Math.Cos(Grad_Differenz / 180 * Math.PI) * 8.0) / (Math.Sqrt(dx * dx + dy * dy)));
                if (sf == 14) Zyklen = (int)(Math.Abs(Math.Sqrt(diff_x * diff_x + diff_y * diff_y - 19*19) * Math.Cos(Grad_Differenz / 180 * Math.PI) * 8.0) / (Math.Sqrt(dx * dx + dy * dy)));

                if (Zyklen > 9999) Zyklen = 9999;
                if (Zyklen < 0) Zyklen = 0;
            }
        }
}

    class Shot
    {
        public int x = 0, y = 0;                                            // aktuelle Position
        public int x1 = 0, y1 = 0;                                          // alte Position
        public int dx = 0, dy=0;                                            // Bewegungsrichtung

        public int dx1 = 0, dx2 = 0, dx3 = 0, dx4 = 0;                      // Teilbewegungen in x Richtung merken(8 Zyklen)
        public int dx5 = 0, dx6 = 0, dx7 = 0, dx8 = 0;  

        public int dy1 = 0, dy2 = 0, dy3 = 0, dy4 = 0;                      // Teilbewegungen in y Richtung merken(8 Zyklen)
        public int dy5 = 0, dy6 = 0, dy7 = 0, dy8 = 0; 

        public int Werte = -1;                                              // Höchste Genaugkeit wird bei 8 Teilbewegungen erreicht

        public int diff_x=0, diff_y=0;                                      // Positionsdifferenz Schuss - Schiff
                           
        public double Grad_Position = 0;                                    // Grad Position Asteroid gegenüber Schiff
        public double Grad_Bewegung = 0;                                    // Grad Bewegung Asteroid
        public double Grad_Differenz = 0;                                   // Grad Differenz

        public int dist = 1000000;                                          // quadratischer Abstand
        public int Abstand = 1000;                                          // kleinster Abstand Schiff<>Schuss (0=Kollision)
        public int AbstandH = 1000;                                         // Abstand beim nächsten Zyklus -> Abfrage ob Hypersprung notwendig
        public int AbstandMM = 1000;                                        // Mittenabstand Schiff<>Schuss
        public int MinAbstand = 1000;                                       // kleinster Abstand (0=Kollision)
        public int Zyklen = 1000;                                           // Zyklen bis zum kleinsten Abstand

        public int Zyklus = 0;                                              // Anzahl der Lebenszyklen
        public int MaxZyklus = 0;                                           // Anzahl der maximalen Lebenszyklen

        public int eigen = 0;                                               // eigener Schuss

        public int Ziel = 99;                                               // Ziel des Schusses (-2=Ufo; -1=Schiff; 0-25=Asteroid; 99=kein Ziel)
        public int ZielZ = 99;                                              // Zyklen bis zum Aufschlag    
       
        public int ok = 0;                                                  // Positionsberechnung richtig (5 = 100% ige Übereinstimmung)
        public int oldpos = -1;                                             // alte Position für Umsortierung merken

        public void cls()
        {
            x = 0; y = 0;
        }

        public void set(int x, int y)
        {
            this.x = x; this.y = y;
        }
        
        public void calc(int ship_x, int ship_y, double Latenz)
        {
            if (y == 0)                                                     // LEER -> RESET (0 keine gültige Position)
            {
                x = 0; y = 0; x1 = 0; y1 = 0; Werte = -1; ok = 0;
                this.dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                this.dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
                Grad_Bewegung = 0; Grad_Differenz = 0; Grad_Position = 0; MinAbstand = 1000; Abstand = 1000; AbstandH = 1000; AbstandMM = 1000; Zyklen = 1000; Zyklus = 0; eigen = 0;
                Ziel = 99; ZielZ = 99;
                return;
            }

            Zyklus++; if (Zyklus > 50) MaxZyklus = Zyklus;

            if (y1 == 0) { x1 = x; y1 = y; Werte = -1; }                    // keine alten Werte vorhanden, aktuellen Wert für alten Werte übernehmen

            dx = x - x1; dy = y - y1;                                       // Bewegung ermitteln

            while (dx < -512) dx += 1024;                                   // dx normalisieren auf -512 ... 511
            while (dx >  511) dx -= 1024;

            while (dy < -384) dy += 768;                                    // dy normalisieren auf -384 ... 383
            while (dy >  383) dy -= 768;

            x1 = x; y1 = y;                                                 // aktuelle Position als alte Position übernehmen

            if ((dx <= 10) && (dx >= -10) && (dy <= 10) && (dy >= -10))     // gültiger dx und dy Wert -> AKTUALISIEREN sonst RESET

            {
                dx8 = dx7; dy8 = dy7;                                       // alte Bewegungen merken
                dx7 = dx6; dy7 = dy6;                                       // alte Bewegungen merken
                dx6 = dx5; dy6 = dy5;                                       // alte Bewegungen merken
                dx5 = dx4; dy5 = dy4;                                       // alte Bewegungen merken
                dx4 = dx3; dy4 = dy3;                                       // alte Bewegungen merken
                dx3 = dx2; dy3 = dy2;                                       // alte Bewegungen merken
                dx2 = dx1; dy2 = dy1;                                       // alte Bewegungen merken
                dx1 = dx;                                                   // alte Bewegungen merken
                dy1 = dy;

                dx = dx1 + dx2 + dx3 + dx4 + dx5 + dx6 + dx7 + dx8;         // Einzelvektoren addieren
                dy = dy1 + dy2 + dy3 + dy4 + dy5 + dy6 + dy7 + dy8;         // Einzelvektoren´addieren
            }
            else
            {
                Werte = -1; Zyklus = 1; Ziel = 99; ZielZ = 99;
                dx = 0; dx1 = 0; dx2 = 0; dx3 = 0; dx4 = 0; dx5 = 0; dx6 = 0; dx7 = 0; dx8 = 0;
                dy = 0; dy1 = 0; dy2 = 0; dy3 = 0; dy4 = 0; dy5 = 0; dy6 = 0; dy7 = 0; dy8 = 0;
            }

            if (Werte < 8) Werte = Werte + 1;
            if (Werte > 8) Werte = 8;

            if (Werte == 1) { dx = dx * 800; dy = dy * 800; dx = dx / 100; dy = dy / 100; }
            if (Werte == 2) { dx = dx * 400; dy = dy * 400; dx = dx / 100; dy = dy / 100; }
            if (Werte == 3) { dx = dx * 267; dy = dy * 267; dx = dx / 100; dy = dy / 100; }
            if (Werte == 4) { dx = dx * 200; dy = dy * 200; dx = dx / 100; dy = dy / 100; }
            if (Werte == 5) { dx = dx * 160; dy = dy * 160; dx = dx / 100; dy = dy / 100; }
            if (Werte == 6) { dx = dx * 133; dy = dy * 133; dx = dx / 100; dy = dy / 100; }
            if (Werte == 7) { dx = dx * 114; dy = dy * 114; dx = dx / 100; dy = dy / 100; }
        
            // -------------------------- Winkelberechnungen ---------------------------- //

            diff_x = ship_x - x; diff_y = ship_y - y;       // Abstand zum Schiff
           
            while (diff_x < -512) diff_x += 1024;           // diff_x normalisieren auf -512 ... 511
            while (diff_x > 511) diff_x -= 1024;

            while (diff_y < -384) diff_y += 768;            // diff_y normalisieren auf -384 ... 383
            while (diff_y > 383) diff_y -= 768;

            if ((diff_x == 0 && diff_y == 0) || (dx == 0 && dy == 0)) 
            {
                Grad_Differenz = 180; Abstand = 1000;
            }
            else
            {
                if (diff_x >= 0) Grad_Position = (Math.Atan2((double)-diff_y, (double)diff_x) * 180.0 / Math.PI) + 90.0;
                if (diff_x < 0) Grad_Position = (Math.Atan2((double)diff_y, (double)-diff_x) * 180.0 / Math.PI) + 270.0;

                if (dx >= 0) Grad_Bewegung = (Math.Atan2((double)-dy, (double)dx) * 180.0 / Math.PI) + 90.0;
                if (dx < 0) Grad_Bewegung = (Math.Atan2((double)dy, (double)-dx) * 180.0 / Math.PI) + 270.0;

                Grad_Differenz = Grad_Position - Grad_Bewegung;
                if (Grad_Differenz > 180) Grad_Differenz = Grad_Differenz - 360;
                if (Grad_Differenz < -180) Grad_Differenz = Grad_Differenz + 360;
            }

            if (Math.Abs(Grad_Differenz) < 90) // bewegt sich auf das Schiff zu 
            {
                MinAbstand = (int)Math.Abs(Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y)) * Math.Sin(Grad_Differenz / 180.0 * Math.PI));
            }
            else MinAbstand = 9999; // bewegt sich vom Schiff weg oder bleibt gleich

            AbstandMM = (int)Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y));
            // AbstandH = (int)(Math.Sqrt(((Double)diff_x - (Double)dx / 4.0) * ((Double)diff_x - (Double)dx / 4.0) + ((Double)diff_y - (Double)dy / 4.0) * ((Double)diff_y - (Double)dy / 4.0)));
            AbstandH = (int)(Math.Sqrt(((Double)diff_x - (Double)dx / 4.0 - (Double)dx / 8.0 * Latenz) * ((Double)diff_x - (Double)dx / 4.0 - (Double)dx / 8.0 * Latenz) + ((Double)diff_y - (Double)dy / 4.0 - (Double)dy / 8.0 * Latenz) * ((Double)diff_y - (Double)dy / 4.0 - (Double)dy / 8.0 * Latenz)));

            MinAbstand = MinAbstand - 12; Abstand = AbstandMM - 12; AbstandH = AbstandH - 12; // 16 -> 12
 
            if (AbstandH < 0) AbstandH = 0;
            if (Abstand < 0) Abstand = 0;
            if (MinAbstand < 0) MinAbstand = 0;
            if (MinAbstand > 1000) MinAbstand = 1000;

            Zyklen = (int)(Math.Abs(Math.Sqrt(diff_x * diff_x + diff_y * diff_y - 12 * 12) * Math.Cos(Grad_Differenz / 180 * Math.PI) * 8.0) / (Math.Sqrt(dx * dx + dy * dy)));

            if (Zyklen > 1000) Zyklen = 1000;
            if (Zyklen < 0) Zyklen = 0;

            if ((dx > 64) || (dx < -64) || (dy > 64) || (dy < -64)) eigen = 0;

            if (Zyklus <= 1)
            {
                 if ((AbstandMM <= 32)) 
                 {
                     eigen = 1;
                     // if ((dx == 0) && (dy == 0))
                     // {
                        // dx = (int)((double)-diff_x/(double)AbstandMM * 64.0);
                        // dy = (int)((double)-diff_y/(double)AbstandMM * 64.0);
                        // x1 = x - (dx/8);
                        // y1 = y - (dy/8);
                     // }
                 }
                 else eigen = 0;
            }
        }
    }

    class Daten
    {
        public int[] Ship_dx = new int[256];
        public int[] Ship_dy = new int[256];
        public int[] Schuss_dx = new int[256];
        public int[] Schuss_dy = new int[256];

        public int[] dx = new int[5] {0,0,0,0,0};
        public int[] dy = new int[5] {0,0,0,0,0};

        public void Set(int Nr, int Ship__dx, int Ship__dy, int Schuss__dx, int Schuss__dy)
        {
            Ship_dx[Nr] = Ship__dx;
            Ship_dy[Nr] = Ship__dy;
            Schuss_dx[Nr] = Schuss__dx;
            Schuss_dy[Nr] = Schuss__dy;
        }

        public int get_ship_dx(int sync)
        {
            return (Schuss_dx[sync]*24);
        }

        public int get_ship_dy(int sync)
        {
            return (Schuss_dy[sync]*24);
        }

        public int get_Schuss_dx(int sync)
        {
            return (Schuss_dx[sync]);
        }

        public int get_Schuss_dy(int sync)
        {
            return (Schuss_dy[sync]);
        }

        public double get_Schuss_v(int sync)
        {
            return (Math.Sqrt((Schuss_dy[sync] * Schuss_dy[sync]) + (Schuss_dx[sync] * Schuss_dx[sync])));
        }

        public bool in_Sync(int sync, int ship_dx, int ship_dy)
        {
            if ((sync >= 0) && (sync <= 255))
            {
                if ((ship_dx == 0) && (ship_dy == 0)) return true;
                if ((Ship_dx[sync] == ship_dx) && (Ship_dy[sync] == ship_dy)) return true; else return false;
            }
            else return false;
        }

        public int resync_all(int sync, int ship_dx, int ship_dy)
        {
            if ((Ship_dx[sync] == ship_dx) && (Ship_dy[sync] == ship_dy)) return sync;

            for (int i = 0; i < 128; i++)
            {
                if ((sync-i)>0)   if ((Ship_dx[(sync - i)] == ship_dx) && (Ship_dy[(sync - i)] == ship_dy)) return (sync - i);
                if ((sync+i)<256) if ((Ship_dx[(sync + i)] == ship_dx) && (Ship_dy[(sync + i)] == ship_dy)) return (sync + i); 
            }

            return 1;
        }

        public int resync(int sync, int ship_dx, int ship_dy)
        {
            int links = sync - 1; if (links < 0) links = 255;
            int rechts = sync + 1; if (rechts > 255) rechts = 0;
            int links1 = links - 1; if (links1 < 0) links1 = 255;
            int rechts1 = rechts + 1; if (rechts1 > 255) rechts1 = 0;

            if ((Ship_dx[sync] == ship_dx) && (Ship_dy[sync] == ship_dy)) return sync;
            if ((Ship_dx[links] == ship_dx) && (Ship_dy[links] == ship_dy)) return links;
            if ((Ship_dx[rechts] == ship_dx) && (Ship_dy[rechts] == ship_dy)) return rechts;
            if ((Ship_dx[links1] == ship_dx) && (Ship_dy[links1] == ship_dy)) return links1;
            if ((Ship_dx[rechts1] == ship_dx) && (Ship_dy[rechts1] == ship_dy)) return rechts1;

            return sync;
        }

        public int SyncA(int Ship__dx, int Ship__dy)
        {
            for (int i = 3; i >= 0; i--)
            {
                dx[i+1] = dx[i];
                dx[i+1] = dy[i];
            }
            dx[0] = Ship__dx;
            dy[0] = Ship__dy;

            for (int i = 0; i < 256; i++)
            {
                if ((Ship_dx[i] == dx[0]) && (Ship_dy[i] == dy[0]) && (Ship_dx[(i + 1) % 256] == dx[1]) && (Ship_dy[(i + 1) % 256] == dy[1]) && (Ship_dx[(i + 2) % 256] == dx[2]) && (Ship_dy[(i + 2) % 256] == dy[2]) && (Ship_dx[(i + 3) % 256] == dx[3]) && (Ship_dy[(i + 3) % 256] == dy[3]) && (Ship_dx[(i + 4) % 256] == dx[4]) && (Ship_dy[(i + 4) % 256] == dy[4])) return i;
            }

            for (int i = 0; i < 256; i++)
            {
                if ((Ship_dx[i] == dx[4]) && (Ship_dy[i] == dy[4]) && (Ship_dx[(i + 1) % 256] == dx[3]) && (Ship_dy[(i + 1) % 256] == dy[3]) && (Ship_dx[(i + 2) % 256] == dx[2]) && (Ship_dy[(i + 2) % 256] == dy[2]) && (Ship_dx[(i + 3) % 256] == dx[1]) && (Ship_dy[(i + 3) % 256] == dy[1]) && (Ship_dx[(i + 4) % 256] == dx[0]) && (Ship_dy[(i + 4) % 256] == dy[0])) return ((i+4)%256);
            }

            return -1;
        }

        public int SyncSchuss(int Ship__dx, int Ship__dy,int Schuss__dx, int Schuss__dy)
        {
            for (int i = 0; i < 256; i++)
            {
                if ((Schuss_dx[i] == Schuss__dx) && (Schuss_dy[i] == Schuss__dy) && (Ship_dx[i] == Ship__dx) && (Ship_dy[i] == Ship__dy)) return i;
            }
            return -1;
        }

        public int SyncB(int Schuss__dx, int Schuss__dy)
        {
            for (int i = 0; i < 256; i++ )
            {
                if ((Schuss_dx[i] == Schuss__dx) && (Schuss_dy[i] == Schuss__dy)) return i;
            }
            return -1;
        }

        public int SyncC(int Ship__dx, int Ship__dy, int Schuss__dx, int Schuss__dy)
        {
            for (int i = 0; i < 256; i++)
            {
                if ((Ship_dx[i] == Ship__dx) && (Ship_dy[i] == Ship__dy) && (Schuss_dx[i] == Schuss__dx) && (Schuss_dy[i] == Schuss__dy)) return i;
            }

            for (int i = 0; i < 256; i++)
            {
                if ((Ship_dx[i] == Ship__dx) && (Ship_dy[i] == Ship__dy)) return i;
            }

            return -1;
        }

        public void Init()
        {
            Set(0, 1536, 0, 63, 4);
            Set(1, 1536, 0, 63, 0);
            Set(2, 1536, 0, 63, -5);
            Set(3, 1528, -152, 63, -10);
            Set(4, 1504, -296, 62, -14);
            Set(5, 1472, -440, 61, -19);
            Set(6, 1472, -440, 59, -23);
            Set(7, 1416, -584, 57, -27);
            Set(8, 1360, -720, 55, -32);
            Set(9, 1280, -856, 53, -36);
            Set(10, 1280, -856, 50, -39);
            Set(11, 1192, -976, 47, -43);
            Set(12, 1088, -1088, 44, -46);
            Set(13, 976, -1192, 40, -49);
            Set(14, 976, -1192, 36, -52);
            Set(15, 856, -1280, 32, -55);
            Set(16, 720, -1360, 28, -57);
            Set(17, 584, -1416, 24, -59);
            Set(18, 584, -1416, 20, -61);
            Set(19, 440, -1472, 15, -62);
            Set(20, 296, -1504, 11, -63);
            Set(21, 152, -1528, 6, -63);
            Set(22, 152, -1528, 1, -64);
            Set(23, -152, -1528, -3, -64);
            Set(24, -296, -1504, -8, -63);
            Set(25, -296, -1504, -13, -63);
            Set(26, -440, -1472, -17, -61);
            Set(27, -584, -1416, -22, -60);
            Set(28, -720, -1360, -26, -58);
            Set(29, -720, -1360, -30, -56);
            Set(30, -856, -1280, -34, -54);
            Set(31, -976, -1192, -38, -51);
            Set(32, -1088, -1088, -42, -48);
            Set(33, -1088, -1088, -45, -45);
            Set(34, -1192, -976, -48, -42);
            Set(35, -1280, -856, -51, -38);
            Set(36, -1360, -720, -54, -34);
            Set(37, -1360, -720, -56, -30);
            Set(38, -1416, -584, -58, -26);
            Set(39, -1472, -440, -60, -22);
            Set(40, -1504, -296, -61, -17);
            Set(41, -1504, -296, -63, -13);
            Set(42, -1528, -152, -63, -8);
            Set(43, -1536, 0, -64, -3);
            Set(44, -1536, 0, -64, 1);
            Set(45, -1528, 152, -63, 6);
            Set(46, -1528, 152, -63, 11);
            Set(47, -1504, 296, -62, 15);
            Set(48, -1472, 440, -61, 20);
            Set(49, -1416, 584, -59, 24);
            Set(50, -1416, 584, -57, 28);
            Set(51, -1360, 720, -55, 32);
            Set(52, -1280, 856, -52, 36);
            Set(53, -1192, 976, -49, 40);
            Set(54, -1192, 976, -46, 44);
            Set(55, -1088, 1088, -43, 47);
            Set(56, -976, 1192, -39, 50);
            Set(57, -856, 1280, -36, 53);
            Set(58, -856, 1280, -32, 55);
            Set(59, -720, 1360, -27, 57);
            Set(60, -584, 1416, -23, 59);
            Set(61, -440, 1472, -19, 61);
            Set(62, -440, 1472, -14, 62);
            Set(63, -296, 1504, -10, 63);
            Set(64, -152, 1528, -5, 63);
            Set(65, 0, 1536, 0, 63);
            Set(66, 152, 1528, 4, 63);
            Set(67, 296, 1504, 9, 63);
            Set(68, 440, 1472, 14, 62);
            Set(69, 440, 1472, 18, 61);
            Set(70, 584, 1416, 23, 59);
            Set(71, 720, 1360, 27, 57);
            Set(72, 856, 1280, 31, 55);
            Set(73, 856, 1280, 35, 53);
            Set(74, 976, 1192, 39, 50);
            Set(75, 1088, 1088, 42, 47);
            Set(76, 1192, 976, 46, 44);
            Set(77, 1192, 976, 49, 40);
            Set(78, 1280, 856, 52, 36);
            Set(79, 1360, 720, 54, 32);
            Set(80, 1416, 584, 56, 28);
            Set(81, 1416, 584, 58, 24);
            Set(82, 1472, 440, 60, 20);
            Set(83, 1504, 296, 61, 15);
            Set(84, 1528, 152, 62, 11);
            Set(85, 1528, 152, 63, 6);
            Set(86, 1536, 0, 63, 1);
            Set(87, 1536, 0, 63, -3);
            Set(88, 1528, -152, 63, -8);
            Set(89, 1504, -296, 62, -13);
            Set(90, 1504, -296, 61, -17);
            Set(91, 1472, -440, 60, -22);
            Set(92, 1416, -584, 58, -26);
            Set(93, 1360, -720, 56, -30);
            Set(94, 1360, -720, 53, -34);
            Set(95, 1280, -856, 51, -38);
            Set(96, 1192, -976, 48, -42);
            Set(97, 1088, -1088, 45, -45);
            Set(98, 1088, -1088, 41, -48);
            Set(99, 976, -1192, 38, -51);
            Set(100, 856, -1280, 34, -54);
            Set(101, 720, -1360, 30, -56);
            Set(102, 720, -1360, 25, -58);
            Set(103, 584, -1416, 21, -60);
            Set(104, 440, -1472, 17, -61);
            Set(105, 296, -1504, 12, -63);
            Set(106, 296, -1504, 8, -63);
            Set(107, 152, -1528, 3, -64);
            Set(108, -152, -1528, -2, -64);
            Set(109, -152, -1528, -6, -63);
            Set(110, -296, -1504, -11, -63);
            Set(111, -440, -1472, -16, -62);
            Set(112, -584, -1416, -20, -61);
            Set(113, -584, -1416, -25, -59);
            Set(114, -720, -1360, -29, -57);
            Set(115, -856, -1280, -33, -55);
            Set(116, -976, -1192, -37, -52);
            Set(117, -976, -1192, -41, -49);
            Set(118, -1088, -1088, -44, -46);
            Set(119, -1192, -976, -47, -43);
            Set(120, -1280, -856, -50, -39);
            Set(121, -1280, -856, -53, -36);
            Set(122, -1360, -720, -56, -32);
            Set(123, -1416, -584, -58, -27);
            Set(124, -1472, -440, -59, -23);
            Set(125, -1472, -440, -61, -19);
            Set(126, -1504, -296, -62, -14);
            Set(127, -1528, -152, -63, -10);
            Set(128, -1536, 0, -64, -5);
            Set(129, -1536, 0, -64, 0);
            Set(130, -1536, 0, -64, 4);
            Set(131, -1528, 152, -63, 9);
            Set(132, -1504, 296, -62, 14);
            Set(133, -1472, 440, -61, 18);
            Set(134, -1472, 440, -59, 23);
            Set(135, -1416, 584, -58, 27);
            Set(136, -1360, 720, -56, 31);
            Set(137, -1280, 856, -53, 35);
            Set(138, -1280, 856, -50, 39);
            Set(139, -1192, 976, -47, 42);
            Set(140, -1088, 1088, -44, 46);
            Set(141, -976, 1192, -41, 49);
            Set(142, -976, 1192, -37, 52);
            Set(143, -856, 1280, -33, 54);
            Set(144, -720, 1360, -29, 56);
            Set(145, -584, 1416, -25, 58);
            Set(146, -584, 1416, -20, 60);
            Set(147, -440, 1472, -16, 61);
            Set(148, -296, 1504, -11, 62);
            Set(149, -152, 1528, -6, 63);
            Set(150, -152, 1528, -2, 63);
            Set(151, 152, 1528, 3, 63);
            Set(152, 296, 1504, 8, 63);
            Set(153, 296, 1504, 12, 62);
            Set(154, 440, 1472, 17, 61);
            Set(155, 584, 1416, 21, 60);
            Set(156, 720, 1360, 25, 58);
            Set(157, 720, 1360, 30, 56);
            Set(158, 856, 1280, 34, 53);
            Set(159, 976, 1192, 38, 51);
            Set(160, 1088, 1088, 41, 48);
            Set(161, 1088, 1088, 45, 45);
            Set(162, 1192, 976, 48, 41);
            Set(163, 1280, 856, 51, 38);
            Set(164, 1360, 720, 53, 34);
            Set(165, 1360, 720, 56, 30);
            Set(166, 1416, 584, 58, 25);
            Set(167, 1472, 440, 60, 21);
            Set(168, 1504, 296, 61, 17);
            Set(169, 1504, 296, 62, 12);
            Set(170, 1528, 152, 63, 8);
            Set(171, 1536, 0, 63, 3);
            Set(172, 1536, 0, 63, -2);
            Set(173, 1528, -152, 63, -6);
            Set(174, 1528, -152, 62, -11);
            Set(175, 1504, -296, 61, -16);
            Set(176, 1472, -440, 60, -20);
            Set(177, 1416, -584, 58, -25);
            Set(178, 1416, -584, 56, -29);
            Set(179, 1360, -720, 54, -33);
            Set(180, 1280, -856, 52, -37);
            Set(181, 1192, -976, 49, -41);
            Set(182, 1192, -976, 46, -44);
            Set(183, 1088, -1088, 42, -47);
            Set(184, 976, -1192, 39, -50);
            Set(185, 856, -1280, 35, -53);
            Set(186, 856, -1280, 31, -56);
            Set(187, 720, -1360, 27, -58);
            Set(188, 584, -1416, 23, -59);
            Set(189, 440, -1472, 18, -61);
            Set(190, 440, -1472, 14, -62);
            Set(191, 296, -1504, 9, -63);
            Set(192, 152, -1528, 4, -64);
            Set(193, 0, -1536, 0, -64);
            Set(194, -152, -1528, -5, -64);
            Set(195, -296, -1504, -10, -63);
            Set(196, -440, -1472, -14, -62);
            Set(197, -440, -1472, -19, -61);
            Set(198, -584, -1416, -23, -59);
            Set(199, -720, -1360, -27, -58);
            Set(200, -856, -1280, -32, -56);
            Set(201, -856, -1280, -36, -53);
            Set(202, -976, -1192, -39, -50);
            Set(203, -1088, -1088, -43, -47);
            Set(204, -1192, -976, -46, -44);
            Set(205, -1192, -976, -49, -41);
            Set(206, -1280, -856, -52, -37);
            Set(207, -1360, -720, -55, -33);
            Set(208, -1416, -584, -57, -29);
            Set(209, -1416, -584, -59, -25);
            Set(210, -1472, -440, -61, -20);
            Set(211, -1504, -296, -62, -16);
            Set(212, -1528, -152, -63, -11);
            Set(213, -1528, -152, -63, -6);
            Set(214, -1536, 0, -64, -2);
            Set(215, -1536, 0, -64, 3);
            Set(216, -1528, 152, -63, 8);
            Set(217, -1504, 296, -63, 12);
            Set(218, -1504, 296, -61, 17);
            Set(219, -1472, 440, -60, 21);
            Set(220, -1416, 584, -58, 25);
            Set(221, -1360, 720, -56, 30);
            Set(222, -1360, 720, -54, 34);
            Set(223, -1280, 856, -51, 38);
            Set(224, -1192, 976, -48, 41);
            Set(225, -1088, 1088, -45, 45);
            Set(226, -1088, 1088, -42, 48);
            Set(227, -976, 1192, -38, 51);
            Set(228, -856, 1280, -34, 53);
            Set(229, -720, 1360, -30, 56);
            Set(230, -720, 1360, -26, 58);
            Set(231, -584, 1416, -22, 60);
            Set(232, -440, 1472, -17, 61);
            Set(233, -296, 1504, -13, 62);
            Set(234, -296, 1504, -8, 63);
            Set(235, -152, 1528, -3, 63);
            Set(236, 152, 1528, 1, 63);
            Set(237, 152, 1528, 6, 63);
            Set(238, 296, 1504, 11, 62);
            Set(239, 440, 1472, 15, 61);
            Set(240, 584, 1416, 20, 60);
            Set(241, 584, 1416, 24, 58);
            Set(242, 720, 1360, 28, 56);
            Set(243, 856, 1280, 32, 54);
            Set(244, 976, 1192, 36, 52);
            Set(245, 976, 1192, 40, 49);
            Set(246, 1088, 1088, 44, 46);
            Set(247, 1192, 976, 47, 42);
            Set(248, 1280, 856, 50, 39);
            Set(249, 1280, 856, 53, 35);
            Set(250, 1360, 720, 55, 31);
            Set(251, 1416, 584, 57, 27);
            Set(252, 1472, 440, 59, 23);
            Set(253, 1472, 440, 61, 18);
            Set(254, 1504, 296, 62, 14);
            Set(255, 1528, 152, 63, 9);
        }
    }

    class GameStatus
    {
        public int FrameLimit = 18000;

        public int HPause = 0;                                          // Zähler für Sperre Hyperjumps
        public Daten SYNC = new Daten();                                // Daten für SYNC Byte
        public bool ship_present;                                       // Schiff sichtbar
        public int ship_x;                                              // Mittelpunkt des Schiffs
        public int ship_y;
        public int ship_dx;                                             // Blickrichtung des Schiffes
        public int ship_dy;
        public int ship_dx1 = 0, ship_dy1 = 0, sync1 = 1;               // alte Werte für Sync Ermittlung
        public int ship_dx2 = 0, ship_dy2 = 0, sync2 = 1;               // alte Werte für Sync Ermittlung
        public int ship_dx3 = 0, ship_dy3 = 0, sync3 = 1;               // alte Werte für Sync Ermittlung
        public int ship_dx4 = 0, ship_dy4 = 0, sync4 = 1;               // alte Werte für Sync Ermittlung
        public bool saucer_present;                                     // UFO sichtbar
        public int saucer_x;                                            // Mittelpunkt des UFOs
        public int saucer_y;
        public int saucer_size;                                         // Größe: 15 = groß, 14 = klein
        public int nasteroids;                                          // Anzahl Asteroiden
        public Asteroid[] asteroids = new Asteroid[100];                // Feldgrösse x2 (+ Puffer für Umsortierung)
        public int nshots;                                              // Anzahl Schüsse
        public int nshots_eigen = 0;                                    // Anzahl eigener Schüsse
        public Shot[] shots = new Shot[20];                             // Feldgrösse x2 (+ Puffer für Umsortierung)
        public int Punkte = 0;                                          // Punkte
        public int HTPunkte = 0;                                        // Punkte Überlauf (x*100T)
        public int Schiffe = 0;                                         // Anzahl Schiffe
        public int AltSchiffe = 0;                                      // Anzahl Schiffe vorige Abfrage
        public int Frames = 0;                                          // verlorene Frames
        public int Latenz = 0;                                          // Latenz
        public long SLatenz = 0;                                        // Summe Latenzen
        public double DLatenz = 0;                                      // Durchschnittliche Latenz
        public long TicksStart = 0;                                     // Startzeit für Zeitmessung
        public long Ticks = 0;                                          // gespielte Zeit
        public int MaxSchiffe = 0;                                      // höchste Lebensanzahl
        public int MinSchiffe = 3;                                      // kleinste Lebensanzahl
        public int MaxAsteroiden = 0;                                   // höchste Asteroidenanzahl
        public int MaxLatenz = 0;                                       // größte Latenz
        public int MaxFrames = 0;                                       // maximal verlorene Frames
        public int AnzFrames = 0;                                       // Anzahl der gespielten Frames
        public int AnzFramesOld = 0;                                    // Anzahl der Frames vor einer Runde
        public int LostFrames = 0;                                      // Anzahl der verlorenen Frames
        public int JumpsA = 0;                                          // Hyperjumps wegen Asteroiden
        public int JumpsS = 0;                                          // Hyperjumps wegen Schüsse
        public int JumpsU = 0;                                          // Hyperjumps wegen UFO
        public int Schüsse = 0;                                         // Anzahl der abgegebenen Schüsse  
        public long Auslastung = 0;                                     // Auslastung Schüsse
        public long AuslastungZ = 0;                                    // Auslastung Schüsse Anzahl Zyklen                     

        public bool pause = false;                                      // Schuss Pause (1x Schuss, 1x Pause, 1x Schuss)

        public int Schussverzögerung = 0;                               // Wie oft konnte kein Schuss abgegeben werden da bereits 4 Schüsse unterwegs

        public int ZielDrehung = 99;                                    // -2 = UFO; 0 bis 98 = Asteroid; 99 = kein Ziel;
        public int ZielSchuss = 99;                                     // -2 = UFO; 0 bis 98 = Asteroid; 99 = kein Ziel;

        public int Ziel1_Frames = 0;                                    // benötigte Frames bis zum Aufschlag;
        public int Ziel2_Frames = 0;                                    // benötigte Frames bis zum Aufschlag;

        public int Runde = 1;                                           // Zähler für Runden

        public int SSync = 1;                                           // Synchronisationsbyte für genaue Blickrichtung des Schiffes ... Sendentelegramm
        public int ESync = 1;                                           // Synchronisationsbyte für genaue Blickrichtung des Schiffes ... Empfangstelegramm
        public int ESyncVorher = 1;                                     // ESyncVorher ... vor Korrektur durch Neusynchronisation

        public int AddSync = 0;                                         // Sync ändern - Rechtsdrehung +1, Linksdrehung -1

        public bool Synchron = false;                                   // Synchron Ja oder Nein
        public int  AnzSyncErr = 0;                                         // Anzahl Sync Fehler

        public int[] sync_bei_ping = new int[256];                      // Sync Wert beim ping [0-255] (Sendetelegramm) merken 
        public int   oldeping = 0;                                      // alten eping (ping im Empfangstelegramm) merken für Reihenfolgeermittlung
        public int   Anz_eping_in_Reihe = 0;                            // Anzahl der in Reihe empfangenen eping (ping im Empfangstelegramm) 
        public int[] ship_dx_bei_ping = new int[256];                   // bei ping[0-255] Ship_dx eintragen (ping im Empfangstelegramme)
        public int[] ship_dy_bei_ping = new int[256];                   // bei ping[0-255] Ship_dy eintragen (ping im Empfangstelegramme)
        
        public int[] Latenz60 = new int[60];                            // Durchschnittliche Latenz in 1 Sekunde ermitteln
        public int PosLatenz60 = 0;

        public int Test = 0;

        public bool game_over = false;                                  // Wird ein Game Over empfangen
        public bool busy = false;                                       // Wird ein busy empfangen
        public bool run = false;                                        // Wird korrektes Startbyte empfangen
        public bool nothing = false;                                    // Nichts wird empfangen
                                   
        public Schiff ship = new Schiff();
        public UFO saucer = new UFO();

        public void clear()
        {
            ship_present = false; saucer_present = false;
            nasteroids = 0; nshots = 0;
            ZielDrehung = 99; ZielSchuss = 99;
            Runde = 1;
            JumpsA = 0; JumpsS = 0; JumpsU = 0;
            MaxAsteroiden = 0; MaxSchiffe = 0; MinSchiffe = 3; MaxLatenz = 0;
            MaxFrames = 0; AnzFrames = 0; AnzFramesOld = 0; LostFrames = 0;
            Punkte = 0; HTPunkte = 0;
            Schüsse = 0;
            oldeping = 0;
            Anz_eping_in_Reihe = 0;
            SLatenz = 0; DLatenz = 0;
            AddSync = 0; AnzSyncErr = 0;

            pause = false;

            Auslastung = 0;
            AuslastungZ = 0;

            for (int i = 0; i < 60; i++) Latenz60[i] = 0;
            for (int i = 0; i < 100; i++) asteroids[i] = new Asteroid();
            for (int i = 0; i < 20; i++) shots[i] = new Shot();

            SYNC.Init();
        }

        public void reset()
        {
            ship_present = false;
            saucer_present = false;
            nasteroids = 0;
            nshots = 0;
            Punkte = 0;
            Schiffe = 0;

            ZielDrehung = 99; ZielSchuss = 99;

            for (int i = 0; i < 26; i++)                                // 26 = max Asteroiden
            {
                asteroids[i].x = 0;
                asteroids[i].y = 0;
                asteroids[i].type = 0;
                asteroids[i].sf = 0;
            }

            for (int i = 0; i < 6; i++)                                 // 6 = max Schüsse
            {
                shots[i].x = 0;
                shots[i].y = 0;
            }
        }

        public bool getroffen()
        {
            bool ret = false;

            for (int i = 0; i < nshots; i++) if ((shots[i].AbstandH <= 0) && (shots[i].eigen == 0)) {ret = true; JumpsS++;}
            for (int i = 0; i < nasteroids; i++) if (asteroids[i].AbstandH <= 0) {ret = true; JumpsA++;}
            if (saucer.AbstandH <= 0) {ret = true; JumpsU++;}

            return ret;
        }

        public double Abweichung_W(int Ziel, int sync, double Latenz)
        {
            double Abweichung = 0;
            double Zyklus = 0;

            double a = 0;
            double b = 0;
            double c = 0;
            double x1 = 0;
            double x2 = 0;

            // Latenz--; if (Latenz < 0) Latenz = 0;

            if ((Ziel >= 0) && (Ziel < 99))
            {
                // Quadratische Gleichung lösen ... Kollision Schuss Asteroid

                double diff_x = asteroids[Ziel].diff_x - (int)((double)asteroids[Ziel].dx / 8.0 * Latenz);
                double diff_y = asteroids[Ziel].diff_y - (int)((double)asteroids[Ziel].dy / 8.0 * Latenz);

                a = SYNC.get_Schuss_v(sync) * SYNC.get_Schuss_v(sync) - (asteroids[Ziel].dx * asteroids[Ziel].dx) - (asteroids[Ziel].dy * asteroids[Ziel].dy);
                b = (-2 * -diff_x * asteroids[Ziel].dx) + (-2 * -diff_y * asteroids[Ziel].dy);
                c = -(diff_x * diff_x) - (diff_y * diff_y);

                x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                if (x1 > 0) Zyklus = x1;
                if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                // Winkelabweichung bei aktueller Ausrichtung ermitteln

                Abweichung = -WinkelDifferenz(Winkel((int)(-diff_x + (asteroids[Ziel].dx * Zyklus)), (int)(-diff_y + (asteroids[Ziel].dy * Zyklus))), Winkel(SYNC.get_ship_dx(sync), SYNC.get_ship_dy(sync)));
            }

            if (Ziel == -2)
            {
                // Quadratische Gleichung lösen ... Kollision Schuss Ufo

                double diff_x = saucer.diff_x - (int)((double)saucer.dx / 8.0 * Latenz);
                double diff_y = saucer.diff_y - (int)((double)saucer.dy / 8.0 * Latenz);

                a = SYNC.get_Schuss_v(sync) * SYNC.get_Schuss_v(sync) - (saucer.dx * saucer.dx) - (saucer.dy * saucer.dy);
                b = (-2 * -diff_x * saucer.dx) + (-2 * -diff_y * saucer.dy);
                c = -(diff_x * diff_x) - (diff_y * diff_y);

                x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                if (x1 > 0) Zyklus = x1;
                if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                // Winkelabweichung bei aktueller Ausrichtung ermitteln

                Abweichung = -WinkelDifferenz(Winkel((int)(-diff_x + (saucer.dx * Zyklus)), (int)(-diff_y + (saucer.dy * Zyklus))), Winkel(SYNC.get_ship_dx(sync), SYNC.get_ship_dy(sync)));
            }

            return Abweichung;
        }

        public double Winkel(int diff_x, int diff_y)
        {
            double Grad = 0;

            if ((diff_x != 0) || (diff_y != 0))
            {
                if (diff_x >= 0) Grad = (Math.Atan2((double)-diff_y, (double)diff_x) * 180.0 / Math.PI) + 90.0;
                if (diff_x < 0) Grad = (Math.Atan2((double)diff_y, (double)-diff_x) * 180.0 / Math.PI) + 270.0;
            }

            return Grad;
        }

        public double WinkelDifferenz(double WinkelP, double WinkelM)
        {
            double Grad_Differenz = WinkelP - WinkelM;

            if (Grad_Differenz > 180) Grad_Differenz = Grad_Differenz - 360;

            if (Grad_Differenz < -180) Grad_Differenz = Grad_Differenz + 360;

            return Grad_Differenz;
        }

        public void calc_asteroids()
        {
            int neux = 0, neuy = 0;

            for (int i = 0; i < nasteroids; i++)
            {
                asteroids[i].oldpos = i;
                asteroids[i].ok = 0;                                // 5 = 100% Übereinstimmung; 1 = Abweichung <=8 Pixel; 0 = keine Übereinstimmung festgestellt (neuer Schuss!)

                for (int c = 0; c < 26; c++)
                {
                    if (asteroids[i].ok < 5)                        // Ermitteln ob die neue Position der alte Position plus Bewegung entspricht (100% Übereinstimmung)
                    {
                        neux = asteroids[c].x1 + asteroids[c].dx8;
                        neuy = asteroids[c].y1 + asteroids[c].dy8;

                        if (neux > 1023) neux = neux - 1024;        // neux ... berechnete neue Position auf gültigen Bereich korrigieren
                        if (neux < 0) neux = neux + 1024;

                        if (neuy > 895) neuy = neuy - 768;          // neuy ... berechnete neue Position auf gültigen Bereich korrigieren
                        if (neuy < 128) neuy = neuy + 768;

                        if ((asteroids[i].sf == asteroids[c].sf1) && (neux == asteroids[i].x) && (neuy == asteroids[i].y)) { asteroids[i].ok = 5; asteroids[i].oldpos = c; }
                    }

                    if (asteroids[i].ok < 4)        // Ermitteln ob die neue Position der alte Position plus durchschnittliche Bewegung mit einer Toleranz von +-1 Pixel entspricht
                    {
                        neux = asteroids[c].x1 + (asteroids[c].dx / 8) - asteroids[i].x;
                        neuy = asteroids[c].y1 + (asteroids[c].dy / 8) - asteroids[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        if ((asteroids[i].sf == asteroids[c].sf1) && (neux >= -1 && neux <= 1) && (neuy >= -1 && neuy <= 1)) { asteroids[i].ok = 4; asteroids[i].oldpos = c; }
                    }

                    if (asteroids[i].ok < 3)        // Ermitteln ob die neue Position der alte Position plus durchschnittliche Bewegung mit einer Toleranz von +-2 Pixel entspricht
                    {
                        neux = asteroids[c].x1 + (asteroids[c].dx / 8) - asteroids[i].x;
                        neuy = asteroids[c].y1 + (asteroids[c].dy / 8) - asteroids[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        if ((asteroids[i].sf == asteroids[c].sf1) && (neux >= -2 && neux <= 2) && (neuy >= -2 && neuy <= 2)) { asteroids[i].ok = 3; asteroids[i].oldpos = c; }
                    }

                    if (asteroids[i].ok < 2)        // Ermitteln ob die neue Position der alte Position plus durchschnittliche Bewegung mit einer Toleranz von +-4 Pixel entspricht
                    {
                        neux = asteroids[c].x1 + (asteroids[c].dx / 8) - asteroids[i].x;
                        neuy = asteroids[c].y1 + (asteroids[c].dy / 8) - asteroids[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        if ((asteroids[i].sf == asteroids[c].sf1) && (neux >= -4 && neux <= 4) && (neuy >= -4 && neuy <= 4)) { asteroids[i].ok = 2; asteroids[i].oldpos = c; }
                    }

                    if (asteroids[i].ok < 1)        // Wenn keine 100% Übereinstimmung dann Test ob Abweichung <= 8 Pixel 
                    {
                        neux = asteroids[c].x1 - asteroids[i].x;
                        neuy = asteroids[c].y1 - asteroids[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        if ((asteroids[i].sf == asteroids[c].sf1) && (neux >= -8 && neux <= 8) && (neuy >= -8 && neuy <= 8)) { asteroids[i].ok = 1; asteroids[i].oldpos = c; }
                    }
                    if (asteroids[i].ok == 5) break;
                }
            }
            for (int i = 0; i < nasteroids; i++)
            {
                int o = asteroids[i].oldpos;

                if (o != i)   // alte Daten vor dem Überschreiben retten 
                {
                    asteroids[o + 40].x1 = asteroids[o].x1; asteroids[o + 40].y1 = asteroids[o].y1;
                    asteroids[o + 40].dx1 = asteroids[o].dx1; asteroids[o + 40].dy1 = asteroids[o].dy1;
                    asteroids[o + 40].dx2 = asteroids[o].dx2; asteroids[o + 40].dy2 = asteroids[o].dy2;
                    asteroids[o + 40].dx3 = asteroids[o].dx3; asteroids[o + 40].dy3 = asteroids[o].dy3;
                    asteroids[o + 40].dx4 = asteroids[o].dx4; asteroids[o + 40].dy4 = asteroids[o].dy4;
                    asteroids[o + 40].dx5 = asteroids[o].dx5; asteroids[o + 40].dy5 = asteroids[o].dy5;
                    asteroids[o + 40].dx6 = asteroids[o].dx6; asteroids[o + 40].dy6 = asteroids[o].dy6;
                    asteroids[o + 40].dx7 = asteroids[o].dx7; asteroids[o + 40].dy7 = asteroids[o].dy7;
                    asteroids[o + 40].dx8 = asteroids[o].dx8; asteroids[o + 40].dy8 = asteroids[o].dy8;
                    asteroids[o + 40].Schuss1 = asteroids[o].Schuss1;
                    asteroids[o + 40].Schuss2 = asteroids[o].Schuss2;
                    asteroids[o + 40].Schuss3 = asteroids[o].Schuss3;
                    asteroids[o + 40].Schuss4 = asteroids[o].Schuss4;
                    asteroids[o + 40].Werte = asteroids[o].Werte;
                }
            }
            for (int i = 0; i < nasteroids; i++)
            {
                int o = asteroids[i].oldpos + 40;

                if ((o - 40) != i)   // alte Daten in neue Listenposition übernehmen 
                {
                    asteroids[i].x1 = asteroids[o].x1; asteroids[i].y1 = asteroids[o].y1;
                    asteroids[i].dx1 = asteroids[o].dx1; asteroids[i].dy1 = asteroids[o].dy1;
                    asteroids[i].dx2 = asteroids[o].dx2; asteroids[i].dy2 = asteroids[o].dy2;
                    asteroids[i].dx3 = asteroids[o].dx3; asteroids[i].dy3 = asteroids[o].dy3;
                    asteroids[i].dx4 = asteroids[o].dx4; asteroids[i].dy4 = asteroids[o].dy4;
                    asteroids[i].dx5 = asteroids[o].dx5; asteroids[i].dy5 = asteroids[o].dy5;
                    asteroids[i].dx6 = asteroids[o].dx6; asteroids[i].dy6 = asteroids[o].dy6;
                    asteroids[i].dx7 = asteroids[o].dx7; asteroids[i].dy7 = asteroids[o].dy7;
                    asteroids[i].dx8 = asteroids[o].dx8; asteroids[i].dy8 = asteroids[o].dy8;
                    asteroids[i].Schuss1 = asteroids[o].Schuss1;
                    asteroids[i].Schuss2 = asteroids[o].Schuss2;
                    asteroids[i].Schuss3 = asteroids[o].Schuss3;
                    asteroids[i].Schuss4 = asteroids[o].Schuss4;
                    asteroids[i].Werte = asteroids[o].Werte;
                }
            }
        }

        public void calc_shots()
        {
            int neux = 0, neuy = 0;

            for (int i = 0; i < nshots; i++)
            {
                shots[i].oldpos = i;
                shots[i].ok = 0;                    // 5 = 100% Übereinstimmung; 1 = Abweichung <=10 Pixel; 0 = keine Übereinstimmung festgestellt (neuer Schuss!)
                
                for (int c = 0; c < 10; c++)
                {
                    if (shots[i].ok < 5)            // Ermitteln ob die neue Position der alte Position plus Bewegung entspricht (100% Übereinstimmung)
                    {
                        neux = shots[c].x1 + shots[c].dx8;
                        neuy = shots[c].y1 + shots[c].dy8;

                        if (neux > 1023) neux = neux - 1024;        // neux ... berechnete neue Position auf gültigen Bereich korrigieren
                        if (neux < 0) neux = neux + 1024;

                        if (neuy > 895) neuy = neuy - 768;          // neuy ... berechnete neue Position auf gültigen Bereich korrigieren
                        if (neuy < 128) neuy = neuy + 768;

                        if ((neux == shots[i].x) && (neuy == shots[i].y)) { shots[i].ok = 5; shots[i].oldpos = c; }
                    }

                    if (shots[i].ok < 4)            // Ermitteln ob die neue Position der alte Position plus durchschnittliche Bewegung mit einer Toleranz von +-1 Pixel entspricht
                    {
                        neux = shots[c].x1 + (shots[c].dx / 8) - shots[i].x;
                        neuy = shots[c].y1 + (shots[c].dy / 8) - shots[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        if ((neux >= -1 && neux <= 1) && (neuy >= -1 && neuy <= 1)) { shots[i].ok = 4; shots[i].oldpos = c; }
                    }

                    if (shots[i].ok < 3)            // Ermitteln ob die neue Position der alte Position plus durchschnittliche Bewegung mit einer Toleranz von +-2 Pixel entspricht
                    {
                        neux = shots[c].x1 + (shots[c].dx / 8) - shots[i].x;
                        neuy = shots[c].y1 + (shots[c].dy / 8) - shots[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        if ((neux >= -2 && neux <= 2) && (neuy >= -2 && neuy <= 2)) { shots[i].ok = 3; shots[i].oldpos = c; }
                    }

                    if (shots[i].ok < 2)            // Ermitteln ob die neue Position der alte Position plus durchschnittliche Bewegung mit einer Toleranz von +-4 Pixel entspricht
                    {
                        neux = shots[c].x1 + (shots[c].dx / 8) - shots[i].x;
                        neuy = shots[c].y1 + (shots[c].dy / 8) - shots[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        if ((neux >= -4 && neux <= 4) && (neuy >= -4 && neuy <= 4)) { shots[i].ok = 2; shots[i].oldpos = c; }
                    }

                    if (shots[i].ok < 1)            // Wenn keine 100% Übereinstimmung dann Test ob Abweichung <= 10 Pixel 
                    {
                        neux = shots[c].x1 - shots[i].x;
                        neuy = shots[c].y1 - shots[i].y;

                        while (neux < -512) neux += 1024;           // diff_x normalisieren auf -512 ... 511
                        while (neux > 511) neux -= 1024;

                        while (neuy < -384) neuy += 768;            // diff_y normalisieren auf -384 ... 383
                        while (neuy > 383) neuy -= 768;

                        // if ((neux >= -10 && neux <= 10) && (neuy >= -10 && neuy <= 10)) { shots[i].ok = 1; shots[i].oldpos = c; }
                    }
                    if (shots[i].ok == 5) break;
                }

            }
            for (int i = 0; i < nshots; i++)
            {
                int o = shots[i].oldpos;

                if (o != i)   // alte Daten vor dem Überschreiben retten 
                {
                    shots[o + 10].x1 = shots[o].x1; shots[o + 10].y1 = shots[o].y1;
                    shots[o + 10].dx1 = shots[o].dx1; shots[o + 10].dy1 = shots[o].dy1;
                    shots[o + 10].dx2 = shots[o].dx2; shots[o + 10].dy2 = shots[o].dy2;
                    shots[o + 10].dx3 = shots[o].dx3; shots[o + 10].dy3 = shots[o].dy3;
                    shots[o + 10].dx4 = shots[o].dx4; shots[o + 10].dy4 = shots[o].dy4;
                    shots[o + 10].dx5 = shots[o].dx5; shots[o + 10].dy5 = shots[o].dy5;
                    shots[o + 10].dx6 = shots[o].dx6; shots[o + 10].dy6 = shots[o].dy6;
                    shots[o + 10].dx7 = shots[o].dx7; shots[o + 10].dy7 = shots[o].dy7;
                    shots[o + 10].dx8 = shots[o].dx8; shots[o + 10].dy8 = shots[o].dy8;
                    shots[o + 10].Werte = shots[o].Werte;
                    shots[o + 10].MaxZyklus = shots[o].MaxZyklus;
                    shots[o + 10].Zyklus = shots[o].Zyklus;
                    shots[o + 10].eigen = shots[o].eigen;
                }
            }
            for (int i = 0; i < nshots; i++)
            {
                int o = shots[i].oldpos + 10;

                if ((o - 10) != i)   // alte Daten in neue Listenposition übernehmen 
                {
                    shots[i].x1 = shots[o].x1; shots[i].y1 = shots[o].y1;
                    shots[i].dx1 = shots[o].dx1; shots[i].dy1 = shots[o].dy1;
                    shots[i].dx2 = shots[o].dx2; shots[i].dy2 = shots[o].dy2;
                    shots[i].dx3 = shots[o].dx3; shots[i].dy3 = shots[o].dy3;
                    shots[i].dx4 = shots[o].dx4; shots[i].dy4 = shots[o].dy4;
                    shots[i].dx5 = shots[o].dx5; shots[i].dy5 = shots[o].dy5;
                    shots[i].dx6 = shots[o].dx6; shots[i].dy6 = shots[o].dy6;
                    shots[i].dx7 = shots[o].dx7; shots[i].dy7 = shots[o].dy7;
                    shots[i].dx8 = shots[o].dx8; shots[i].dy8 = shots[o].dy8;
                    shots[i].Werte = shots[o].Werte;
                    shots[i].MaxZyklus = shots[o].MaxZyklus;
                    shots[i].Zyklus = shots[o].Zyklus;
                    shots[i].eigen = shots[o].eigen;
                }
            }

            if (nshots > 2) shots[0].eigen = 1;
            if (nshots > 3) shots[1].eigen = 1;
            if (nshots > 4) shots[2].eigen = 1;
            if (nshots > 5) shots[3].eigen = 1;

            shots[4].eigen = 0;   // 0-3 eigene Schüsse, 4 und 5 sind sicher fremde Schüsse;
            shots[5].eigen = 0;
        }

        public int int256(int Zahl)
        {

            while (Zahl > 255) Zahl-=256;           // Zahl auf 0-256 begrenzen
            while (Zahl < 0)   Zahl+=256;           // Zahl auf 0-256 begrenzen

            return Zahl;
        }

        public void calc_sync(int eping, int sping, int frame)
        {
            int x = 0;
            bool SynchronX = false;
            int start = 0, ende = 0;

            ship_dx_bei_ping[eping] = ship_dx;      // Ship_dx bei Empfangs-Ping eintragen
            ship_dy_bei_ping[eping] = ship_dy;      // Ship_dy bei Empfangs-Ping eintragen
            sync_bei_ping[sping]    = AddSync;      // Syncänderung == gesendeter Befehl -> bei Sende-Ping merken

            if (((eping - oldeping) == 1) || (eping == 0) && (oldeping == 255)) Anz_eping_in_Reihe++; else Anz_eping_in_Reihe = 0;     // Anzahl der in Reihe empfangenen eping
            if (ship_present) for (int l = 0; l <= Frames; l++) ESync = int256(ESync + sync_bei_ping[oldeping]);
      
            ESyncVorher = ESync;

            Synchron = SYNC.in_Sync(ESync, ship_dx, ship_dy);
            if (Synchron == false) AnzSyncErr++;

            if ((Anz_eping_in_Reihe > 3) && (Synchron == false))
            {
                x = eping; sync1 = sync_bei_ping[x]; ship_dx1 = ship_dx_bei_ping[x]; ship_dy1 = ship_dy_bei_ping[x];
                x = x - 1; if (x < 0) x = 255; sync2 = sync_bei_ping[x]; ship_dx2 = ship_dx_bei_ping[x]; ship_dy2 = ship_dy_bei_ping[x];
                x = x - 1; if (x < 0) x = 255; sync3 = sync_bei_ping[x]; ship_dx3 = ship_dx_bei_ping[x]; ship_dy3 = ship_dy_bei_ping[x];
                x = x - 1; if (x < 0) x = 255; sync4 = sync_bei_ping[x]; ship_dx4 = ship_dx_bei_ping[x]; ship_dy4 = ship_dy_bei_ping[x];

                if ((sync1 == 1) && (sync2 == 1) && (sync3 == 1) && (sync4 == 1))        // Plus == Rechtsdrehung
                {
                    for (int b = 0; b < 256; b++)
                    {
                        if ((SYNC.Ship_dx[(b + 3) % 256] == ship_dx1) && (SYNC.Ship_dx[(b + 2) % 256] == ship_dx2) && (SYNC.Ship_dx[(b + 1) % 256] == ship_dx3) && (SYNC.Ship_dx[b % 256] == ship_dx4)
                        && (SYNC.Ship_dy[(b + 3) % 256] == ship_dy1) && (SYNC.Ship_dy[(b + 2) % 256] == ship_dy2) && (SYNC.Ship_dy[(b + 1) % 256] == ship_dy3) && (SYNC.Ship_dy[b % 256] == ship_dy4))
                        {
                            ESync = (b + 3) % 256; break;
                        }
                    }
                }

                if ((sync1 == -1) && (sync2 == -1) && (sync3 == -1) && (sync4 == -1))   // Minus == Linksdrehung
                {
                    for (int b = 0; b < 256; b++)
                    {
                        if ((SYNC.Ship_dx[(b + 3) % 256] == ship_dx4) && (SYNC.Ship_dx[(b + 2) % 256] == ship_dx3) && (SYNC.Ship_dx[(b + 1) % 256] == ship_dx2) && (SYNC.Ship_dx[b % 256] == ship_dx1)
                        && (SYNC.Ship_dy[(b + 3) % 256] == ship_dy4) && (SYNC.Ship_dy[(b + 2) % 256] == ship_dy3) && (SYNC.Ship_dy[(b + 1) % 256] == ship_dy2) && (SYNC.Ship_dy[b % 256] == ship_dy1))
                        {
                            ESync = b; break;
                        }
                    }
                }
            }

            SynchronX = SYNC.in_Sync(ESync, ship_dx, ship_dy);

            if (SynchronX == false) ESync = SYNC.resync(ESync, ship_dx, ship_dy)    ; SynchronX = SYNC.in_Sync(ESync, ship_dx, ship_dy);
            if (SynchronX == false) ESync = SYNC.resync_all(ESync, ship_dx, ship_dy); SynchronX = SYNC.in_Sync(ESync, ship_dx, ship_dy);

            SSync = ESync;

            start = eping; ende = sping; if (ende < start) ende = ende + 256;
            if ((ende - start) > Math.Round(DLatenz,0)) ende = start + (int)Math.Round(DLatenz,0);

            for (x = start; x <= ende; x++) SSync = SSync + sync_bei_ping[int256(x)]; SSync = int256(SSync); // SSync neu ermitteln

            // if ((AnzFrames > 0) && (AnzFrames < 17999)) FileWrite.Schüsse("Frame:" + AnzFrames.ToString("00000") + " Frame-Nr.:"+frame.ToString("000")+ " Lost:" + Frames.ToString("000") + " Latenz:" + Latenz.ToString("000") + " SP:" + sping.ToString("000") + " SS:" + sync_bei_ping[sping].ToString("+0;-0") + " EP:" + eping.ToString("000") + " ES:" + sync_bei_ping[eping].ToString("+0;-0") + " Ist:" + ESyncVorher.ToString("000") + " Soll:" + ESync.ToString("000") + " SSync:" + SSync.ToString("000") + " "+Synchron.ToString() + " ");

            oldeping = eping;
            AddSync = 0;
        }

        public void calc()
        {
            int x = 0;

            if (Schiffe > MaxSchiffe) MaxSchiffe = Schiffe;
            if ((Schiffe > 0) && (Schiffe < MinSchiffe)) MinSchiffe = Schiffe;
            if (nasteroids > MaxAsteroiden) MaxAsteroiden = nasteroids;
            if (Latenz > MaxLatenz) MaxLatenz = Latenz;
            if (Frames > MaxFrames) MaxFrames = Frames;

            PosLatenz60++; if (PosLatenz60 >= 60) PosLatenz60 = 0; Latenz60[PosLatenz60] = Latenz; SLatenz = 0;
            for (x = 0; x < 60; x++) SLatenz = SLatenz + Latenz60[x];

            SLatenz = SLatenz + Latenz;
            DLatenz = Math.Round((double)SLatenz / 61,3);

            calc_asteroids();
            calc_shots();

            for (int i = 0; i < 26; i++) asteroids[i].calc(ship_x, ship_y,DLatenz+1); // < 26 ... wird sowieso nie mehr erreicht!!
            for (int i = 0; i < 6; i++) shots[i].calc(ship_x, ship_y,DLatenz+1);      // < 6 ... wird sowieso nie mehr erreicht!! 

            nshots_eigen = 0; for (int i = 0; i < nshots; i++) if (shots[i].eigen == 1) nshots_eigen++;

            ship.calc(ship_x, ship_y);
            saucer.calc(saucer_x, saucer_y, saucer_size, ship_x, ship_y, DLatenz+1);
        }

        public void calc_Schussabweichungen(int sync, double Latenz)
        {
            double diff_x = 0, diff_y = 0;

            double a = 0, b = 0, c = 0;
            double x1 = 0, x2 = 0;

            double Zyklus = 0;

            //Latenz--; if (Latenz<0) Latenz=0;

            for (int Ziel = 0; Ziel < nasteroids; Ziel++)
            {
                // Quadratische Gleichung lösen ... Kollision Schuss Asteroid

                diff_x = asteroids[Ziel].diff_x-(int)((double)asteroids[Ziel].dx / 8.0*Latenz);
                diff_y = asteroids[Ziel].diff_y-(int)((double)asteroids[Ziel].dy / 8.0*Latenz);

                a = SYNC.get_Schuss_v(sync) * SYNC.get_Schuss_v(sync) - (asteroids[Ziel].dx * asteroids[Ziel].dx) - (asteroids[Ziel].dy * asteroids[Ziel].dy);
                b = (-2 * -diff_x * asteroids[Ziel].dx) + (-2 * -diff_y * asteroids[Ziel].dy);
                c = -(diff_x * diff_x) - (diff_y * diff_y);

                x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                if (x1 > 0) Zyklus = x1;
                if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                // Winkelabweichung bei aktueller Ausrichtung ermitteln

                asteroids[Ziel].AbweichungW = -WinkelDifferenz(Winkel((int)(-diff_x + (asteroids[Ziel].dx * Zyklus)), (int)(-diff_y + (asteroids[Ziel].dy * Zyklus))), Winkel(SYNC.get_ship_dx(sync), SYNC.get_ship_dy(sync)));
                asteroids[Ziel].AbweichungZ = (int)Math.Ceiling(Zyklus * 8) + 2;
                if (asteroids[Ziel].danger >= 1000) asteroids[Ziel].danger = asteroids[Ziel].danger + (int)Math.Abs((asteroids[Ziel].AbweichungW) / 4.21875); // Zeit zum Drehen einberechnen aber nur wenn nicht auf Kollisionskurs!!!
            }

            {
                // Quadratische Gleichung lösen ... Kollision Schuss Ufo

                diff_x = saucer.diff_x - (int)((double)saucer.dx / 8.0 * Latenz);
                diff_y = saucer.diff_y - -(int)((double)saucer.dy / 8.0 * Latenz);

                a = SYNC.get_Schuss_v(sync) * SYNC.get_Schuss_v(sync) - (saucer.dx * saucer.dx) - (saucer.dy * saucer.dy);
                b = (-2 * -diff_x * saucer.dx) + (-2 * -diff_y * saucer.dy);
                c = -(diff_x * diff_x) - (diff_y * diff_y);

                x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                if (x1 > 0) Zyklus = x1;
                if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                // Winkelabweichung bei aktueller Ausrichtung ermitteln

                saucer.AbweichungW = -WinkelDifferenz(Winkel((int)(-diff_x + (saucer.dx * Zyklus)), (int)(-diff_y + (saucer.dy * Zyklus))), Winkel(SYNC.get_ship_dx(sync), SYNC.get_ship_dy(sync)));
                saucer.AbweichungZ = (int)Math.Ceiling(Zyklus * 8);
            }
        }

        public void calc_Schusstrefferwahrscheinlichkeit()
        {
            double diff_x = 0, diff_y = 0;
            int PosZ_x = 0, PosZ_y = 0;
            int PosS_x = 0, PosS_y = 0;
            int Max_Z = 0;

            double Abstand = 0;

            for (int Schuss = 0; Schuss < nshots; Schuss++)
            {
                Max_Z = 72 - shots[Schuss].Zyklus;
                if (Max_Z < 0) Max_Z = 0;

                shots[Schuss].Ziel = 99;        // Reset
                shots[Schuss].ZielZ = 99;

                for (int Ziel = 0; Ziel < nasteroids; Ziel++)           // Asteroiden

                    for (int Z = 0; Z <= Max_Z; Z++)
                    {
                        PosZ_x = asteroids[Ziel].x + (int)(asteroids[Ziel].dx * Z / 8.0);
                        PosZ_y = asteroids[Ziel].y + (int)(asteroids[Ziel].dy * Z / 8.0);

                        PosS_x = shots[Schuss].x + (int)(shots[Schuss].dx * Z / 8.0);
                        PosS_y = shots[Schuss].y + (int)(shots[Schuss].dy * Z / 8.0);

                        diff_x = PosZ_x - PosS_x;
                        diff_y = PosZ_y - PosS_y;

                        Abstand = Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y));

                        if (Abstand <= asteroids[Ziel].RadiusK)           // Wird Ziel getroffen
                        {
                            int ZielAnzS = 0;

                            for (int S = 0; S < nshots; S++) if (shots[S].Ziel == Ziel) ZielAnzS++;

                            if ((shots[Schuss].ZielZ > Z) && (((ZielAnzS < 4) && (asteroids[Ziel].sf == 0)) || ((ZielAnzS < 3) && (asteroids[Ziel].sf == 15)) || ((ZielAnzS < 1) && (asteroids[Ziel].sf == 14))))  // Ziel übernehmen wenn nähestes Ziel und noch als Ziel übrig;
                            {
                                shots[Schuss].Ziel = Ziel;
                                shots[Schuss].ZielZ = Z;
                            }
                        }
                    }

                for (int Z = 0; Z <= Max_Z; Z++)                       // Ufo
                {

                    PosZ_x = saucer.x + (int)(saucer.dx * Z / 8.0);
                    PosZ_y = saucer.y + (int)(saucer.dy * Z / 8.0);

                    PosS_x = shots[Schuss].x + (int)(shots[Schuss].dx * Z / 8.0);
                    PosS_y = shots[Schuss].y + (int)(shots[Schuss].dy * Z / 8.0);

                    diff_x = PosZ_x - PosS_x;
                    diff_y = PosZ_y - PosS_y;

                    Abstand = Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y));

                    if (Abstand <= saucer.RadiusS)                   // Wird Ziel getroffen
                    {
                        bool bereits_ein_Ziel = false;

                        for (int S = 0; S < nshots; S++) if (shots[S].Ziel == -2) bereits_ein_Ziel = true;

                        if ((shots[Schuss].ZielZ > Z) && (bereits_ein_Ziel == false))   // Ziel übernehmen wenn nähestes Ziel und noch kein Ziel bisheriger Schüsse;
                        {
                            shots[Schuss].Ziel = -2;
                            shots[Schuss].ZielZ = Z;
                        }
                    }
                }
                for (int Z = 0; Z <= Max_Z; Z++)                       // Schiff
                {

                    PosZ_x = ship.x + (int)(ship.dx * Z / 8.0);
                    PosZ_y = ship.y + (int)(ship.dy * Z / 8.0);

                    PosS_x = shots[Schuss].x + (int)(shots[Schuss].dx * Z / 8.0);
                    PosS_y = shots[Schuss].y + (int)(shots[Schuss].dy * Z / 8.0);

                    diff_x = PosZ_x - PosS_x;
                    diff_y = PosZ_y - PosS_y;

                    Abstand = Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y));

                    if (Abstand <= 27)                                      // Wird Schiff getroffen
                    {
                        if (shots[Schuss].ok == 5) shots[Schuss].eigen = 0; // Wenn Schuss OK=5 (Beste Berechnungsgrundlage) dann Schuss von Ufo!

                        bool bereits_ein_Ziel = false;

                        for (int S = 0; S < nshots; S++) if (shots[S].Ziel == -1) bereits_ein_Ziel = true;

                        if ((shots[Schuss].ZielZ > Z) && (bereits_ein_Ziel == false))   // Ziel übernehmen wenn nähestes Ziel und noch kein Ziel bisheriger Schüsse;                        {
                            shots[Schuss].Ziel = -1;
                        shots[Schuss].ZielZ = Z;
                    }
                }
            }

        }

        public int calc_Treffer(int Ziel)
        {
            int anz = 0;

            for (int Schuss = 0; Schuss < nshots; Schuss++)
            {
                if (shots[Schuss].Ziel == Ziel) anz++;
            }
            return anz;
        }

        public void calc_Reihenfolge_Asteroids_TEST(int SyncB)
        {
            double diff_x = 0, diff_y = 0; int AbstandMM = 0;
            double AbweichungW = 0, AbweichungZ = 0;

            for (int Ziel = 0; Ziel < nasteroids; Ziel++)
            {
                asteroids[Ziel].ZDrehung = 799; asteroids[Ziel].ZEntfernung = 199; asteroids[Ziel].ZSumme = 998;
                asteroids[Ziel].ForceLinks = false; asteroids[Ziel].ForceRechts = false; asteroids[Ziel].ForceHold = false;

                for (int Z = 0; Z < 500; Z++)
                {
                    diff_x = (int)(asteroids[Ziel].diff_x - ((double)asteroids[Ziel].dx / 8.0 * (double)Z));    // diff_x nach Z Zyklen
                    diff_y = (int)(asteroids[Ziel].diff_y - ((double)asteroids[Ziel].dy / 8.0 * (double)Z));    // diff_y nach Z Zyklen

                    while (diff_x < -512) diff_x += 1024; while (diff_x > 511) diff_x -= 1024;                  // diff_x normalisieren auf -512 ... 511
                    while (diff_y < -384) diff_y += 768; while (diff_y > 383) diff_y -= 768;                    // diff_y normalisieren auf -384 ... 383

                    AbstandMM = (int)Math.Sqrt((diff_x * diff_x) + (diff_y * diff_y));                          // AbstandMM nach Z Zyklen

                    if (AbstandMM <= (8 * 72))                                                                  // in Schussreichweite
                    {
                        AbweichungW = WinkelDifferenz(Winkel((int)-diff_x, (int)-diff_y), Winkel(SYNC.get_ship_dx(SyncB), SYNC.get_ship_dy(SyncB)));
                        AbweichungW = WinkelDifferenz(Winkel((int)-diff_x, (int)-diff_y), Winkel(SYNC.get_ship_dx(SyncB), SYNC.get_ship_dy(SyncB)));

                        AbweichungZ = AbstandMM / 8;

                        if (((int)Math.Ceiling(Math.Abs(AbweichungW / 4.21875)) + (int)AbweichungZ) <= Z)       // Aufgabe gelöst ... Drehung und Schusszeit gehen sich in Z Zyklen aus
                        {
                            asteroids[Ziel].ZDrehung = (int)Math.Ceiling(Math.Abs(AbweichungW / 4.21875));
                            asteroids[Ziel].ZEntfernung = (int)AbweichungZ; asteroids[Ziel].ZSumme = asteroids[Ziel].ZDrehung + asteroids[Ziel].ZEntfernung;

                            if ((AbweichungW < 0) && (asteroids[Ziel].ZDrehung > 1)) asteroids[Ziel].ForceRechts = false; asteroids[Ziel].ForceLinks = true;
                            if ((AbweichungW > 0) && (asteroids[Ziel].ZDrehung > 1)) asteroids[Ziel].ForceRechts = true; asteroids[Ziel].ForceLinks = false;
                            //if ((AbweichungW < (Winkel(asteroids[Ziel].RadiusS, AbstandMM))) && (AbweichungW > -(Winkel(asteroids[Ziel].RadiusS, AbstandMM))))
                            //{
                            //    asteroids[Ziel].ForceRechts = false; asteroids[Ziel].ForceLinks = false;        // asteroids[Ziel].ForceHold = true;
                            //}
                            break;
                        }
                    }
                }

                if (asteroids[Ziel].sf == 0) if ((asteroids[Ziel].ZSumme < 998) && (asteroids[Ziel].MinAbstand == 0) && (asteroids[Ziel].Zyklen < (asteroids[Ziel].ZSumme + 40 + (int)Math.Round(DLatenz, 0))) && (asteroids[Ziel].Zyklen >= (asteroids[Ziel].ZSumme))) asteroids[Ziel].danger = (int)(asteroids[Ziel].ZSumme); else asteroids[Ziel].danger = (int)(1000 + asteroids[Ziel].ZSumme);
                if (asteroids[Ziel].sf == 15) if ((asteroids[Ziel].ZSumme < 998) && (asteroids[Ziel].MinAbstand == 0) && (asteroids[Ziel].Zyklen < (asteroids[Ziel].ZSumme + 30 + (int)Math.Round(DLatenz, 0))) && (asteroids[Ziel].Zyklen >= (asteroids[Ziel].ZSumme))) asteroids[Ziel].danger = (int)(asteroids[Ziel].ZSumme); else asteroids[Ziel].danger = (int)(1000 + asteroids[Ziel].ZSumme);
                if (asteroids[Ziel].sf == 14) if ((asteroids[Ziel].ZSumme < 998) && (asteroids[Ziel].MinAbstand == 0) && (asteroids[Ziel].Zyklen < (asteroids[Ziel].ZSumme + 20 + (int)Math.Round(DLatenz, 0))) && (asteroids[Ziel].Zyklen >= (asteroids[Ziel].ZSumme))) asteroids[Ziel].danger = (int)(asteroids[Ziel].ZSumme); else asteroids[Ziel].danger = (int)(1000 + asteroids[Ziel].ZSumme);
            }
        }

        public void calc_Reihenfolge_Asteroids(int AktuellesSyncByte)
        {
            int SyncBL = 0;
            int SyncBR = 0;

            double diff_x = 0, diff_y = 0;
            double Abweichung_W=0, Abweichung_Z=0;

            double a = 0, b = 0, c = 0;
            double x1 = 0, x2 = 0;

            double Zyklus = 0;

            for (int Ziel = 0; Ziel < nasteroids; Ziel++)
            {
                SyncBL = AktuellesSyncByte;
                SyncBR = AktuellesSyncByte;

                asteroids[Ziel].ZDrehung = 50;
                asteroids[Ziel].ZEntfernung = 100;
                asteroids[Ziel].ZSumme = 150;
                asteroids[Ziel].ForceLinks = false;
                asteroids[Ziel].ForceRechts = false;

//               if ((asteroids[Ziel].MinAbstand == 0) && (asteroids[Ziel].AbstandMM < 500) && (asteroids[Ziel].Zyklen < 250)) asteroids[Ziel].danger = asteroids[Ziel].Zyklen; else asteroids[Ziel].danger = 2000;

                for (int Z = 0; Z < 45; Z++) // LINKS
                {
                    // Quadratische Gleichung lösen ... Kollision Schuss Asteroid

                    diff_x = (int)(asteroids[Ziel].diff_x - ((double)asteroids[Ziel].dx / 8.0 * (double)Z));
                    diff_y = (int)(asteroids[Ziel].diff_y - ((double)asteroids[Ziel].dy / 8.0 * (double)Z));

                    while (diff_x < -512) diff_x += 1024;           // diff_x normalisieren auf -512 ... 511
                    while (diff_x > 511) diff_x -= 1024;

                    while (diff_y < -384) diff_y += 768;            // diff_y normalisieren auf -384 ... 383
                    while (diff_y > 383) diff_y -= 768;

                    // LINKS

                    a = SYNC.get_Schuss_v(SyncBL) * SYNC.get_Schuss_v(SyncBL) - (asteroids[Ziel].dx * asteroids[Ziel].dx) - (asteroids[Ziel].dy * asteroids[Ziel].dy);
                    b = (-2 * -diff_x * asteroids[Ziel].dx) + (-2 * -diff_y * asteroids[Ziel].dy);
                    c = -(diff_x * diff_x) - (diff_y * diff_y);

                    x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                    x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                    if (x1 > 0) Zyklus = x1;
                    if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                    // Winkelabweichung bei aktueller Ausrichtung ermitteln

                    Abweichung_W = -WinkelDifferenz(Winkel((int)(-diff_x + (asteroids[Ziel].dx * Zyklus)), (int)(-diff_y + (asteroids[Ziel].dy * Zyklus))), Winkel(SYNC.get_ship_dx(SyncBL), SYNC.get_ship_dy(SyncBL)));
                    Abweichung_Z = (int)Math.Ceiling(Zyklus * 8) + 2;

                    if (Math.Abs(Abweichung_W) < 5)
                    {

                        asteroids[Ziel].ZDrehung = Z;
                        asteroids[Ziel].ZEntfernung = (int)Abweichung_Z;

                        if (Abweichung_Z <= 72)
                        {
                            asteroids[Ziel].ZSumme = (int)(Z + Abweichung_Z);
                            if (Z > 5) asteroids[Ziel].ForceLinks = true;
                            break;
                        }
                    }

                    // RECHTS

                    a = SYNC.get_Schuss_v(SyncBR) * SYNC.get_Schuss_v(SyncBR) - (asteroids[Ziel].dx * asteroids[Ziel].dx) - (asteroids[Ziel].dy * asteroids[Ziel].dy);
                    b = (-2 * -diff_x * asteroids[Ziel].dx) + (-2 * -diff_y * asteroids[Ziel].dy);
                    c = -(diff_x * diff_x) - (diff_y * diff_y);

                    x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                    x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                    if (x1 > 0) Zyklus = x1;
                    if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                    // Winkelabweichung bei aktueller Ausrichtung ermitteln

                    Abweichung_W = -WinkelDifferenz(Winkel((int)(-diff_x + (asteroids[Ziel].dx * Zyklus)), (int)(-diff_y + (asteroids[Ziel].dy * Zyklus))), Winkel(SYNC.get_ship_dx(SyncBR), SYNC.get_ship_dy(SyncBR)));
                    Abweichung_Z = (int)Math.Ceiling(Zyklus * 8) + 2;

                    if (Math.Abs(Abweichung_W) < 5)
                    {
                        asteroids[Ziel].ZDrehung = Z;
                        asteroids[Ziel].ZEntfernung = (int)Abweichung_Z;

                        if (Abweichung_Z <= 72)
                        {
                            asteroids[Ziel].ZSumme = (int)(Z + Abweichung_Z);
                            if (Z > 5) asteroids[Ziel].ForceRechts = true;
                            break;
                        }
                    }

                    SyncBL--;
                    SyncBR++;

                    if (SyncBL < 0) SyncBL = 255;
                    if (SyncBR > 255) SyncBR = 0;
                }

                if (asteroids[Ziel].sf == 0)  if ((asteroids[Ziel].ZSumme < 150) && (asteroids[Ziel].MinAbstand == 0) && (asteroids[Ziel].Zyklen < (asteroids[Ziel].ZSumme + 40 + (int)Math.Round(DLatenz,0))) && (asteroids[Ziel].Zyklen >= (asteroids[Ziel].ZSumme))) asteroids[Ziel].danger = (int)(asteroids[Ziel].ZSumme); else asteroids[Ziel].danger = (int)(1000+asteroids[Ziel].ZSumme);
                if (asteroids[Ziel].sf == 15) if ((asteroids[Ziel].ZSumme < 150) && (asteroids[Ziel].MinAbstand == 0) && (asteroids[Ziel].Zyklen < (asteroids[Ziel].ZSumme + 30 + (int)Math.Round(DLatenz,0))) && (asteroids[Ziel].Zyklen >= (asteroids[Ziel].ZSumme))) asteroids[Ziel].danger = (int)(asteroids[Ziel].ZSumme); else asteroids[Ziel].danger = (int)(1000+asteroids[Ziel].ZSumme);
                if (asteroids[Ziel].sf == 14) if ((asteroids[Ziel].ZSumme < 150) && (asteroids[Ziel].MinAbstand == 0) && (asteroids[Ziel].Zyklen < (asteroids[Ziel].ZSumme + 20 + (int)Math.Round(DLatenz,0))) && (asteroids[Ziel].Zyklen >= (asteroids[Ziel].ZSumme))) asteroids[Ziel].danger = (int)(asteroids[Ziel].ZSumme); else asteroids[Ziel].danger = (int)(1000+asteroids[Ziel].ZSumme);

                if (asteroids[Ziel].ZSumme >= 150) { asteroids[Ziel].ZSumme = 150 + (int)Abweichung_Z; asteroids[Ziel].danger = asteroids[Ziel].ZSumme + 2000; }
            }
        }

        public void calc_Reihenfolge_UFO(int AktuellesSyncByte)
        {
            int SyncBL = AktuellesSyncByte, SyncBR = AktuellesSyncByte;

            double diff_x = 0, diff_y = 0;
            double Abweichung_W, Abweichung_Z;

            double a = 0, b = 0, c = 0;
            double x1 = 0, x2 = 0;

            double Zyklus = 0;

            saucer.ZDrehung = 50;
            saucer.ZSumme = 150;
            saucer.ForceLinks = false;
            saucer.ForceRechts = false;

            saucer.danger = 2000;

            if (saucer_present)
            {
                for (int Z = 0; Z < 45; Z++) // LINKS
                {

                    // Quadratische Gleichung lösen ... Kollision Schuss Asteroid

                    diff_x = (int)(saucer.diff_x - ((double)saucer.dx / 8.0 * (double)Z));
                    diff_y = (int)(saucer.diff_y - ((double)saucer.dy / 8.0 * (double)Z));

                    while (diff_x < -512) diff_x += 1024;           // diff_x normalisieren auf -512 ... 511
                    while (diff_x > 511) diff_x -= 1024;

                    while (diff_y < -384) diff_y += 768;            // diff_y normalisieren auf -384 ... 383
                    while (diff_y > 383) diff_y -= 768;

                    // LINKS

                    a = SYNC.get_Schuss_v(SyncBL) * SYNC.get_Schuss_v(SyncBL) - (saucer.dx * saucer.dx) - (saucer.dy * saucer.dy);
                    b = (-2 * -diff_x * saucer.dx) + (-2 * -diff_y * saucer.dy);
                    c = -(diff_x * diff_x) - (diff_y * diff_y);

                    x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                    x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                    if (x1 > 0) Zyklus = x1;
                    if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                    // Winkelabweichung bei aktueller Ausrichtung ermitteln

                    Abweichung_W = -WinkelDifferenz(Winkel((int)(-diff_x + (saucer.dx * Zyklus)), (int)(-diff_y + (saucer.dy * Zyklus))), Winkel(SYNC.get_ship_dx(SyncBL), SYNC.get_ship_dy(SyncBL)));
                    Abweichung_Z = (int)Math.Ceiling(Zyklus * 8) + 2;

                    if (Math.Abs(Abweichung_W) < 5)
                    {
                        saucer.danger = (int)(1000 + Z + Abweichung_Z);
                        saucer.ZDrehung = Z;
                        saucer.ZSumme = (int)(Z + Abweichung_Z);
                        if (Z > 5) saucer.ForceLinks = true;
                        break;
                    }

                    // RECHTS

                    a = SYNC.get_Schuss_v(SyncBR) * SYNC.get_Schuss_v(SyncBR) - (saucer.dx * saucer.dx) - (saucer.dy * saucer.dy);
                    b = (-2 * -diff_x * saucer.dx) + (-2 * -diff_y * saucer.dy);
                    c = -(diff_x * diff_x) - (diff_y * diff_y);

                    x1 = (-b + Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                    x2 = (-b - Math.Sqrt(b * b - 4.0 * a * c)) / (2.0 * a);

                    if (x1 > 0) Zyklus = x1;
                    if ((x2 > 0) && (x2 < x1)) Zyklus = x2;

                    // Winkelabweichung bei aktueller Ausrichtung ermitteln

                    Abweichung_W = -WinkelDifferenz(Winkel((int)(-diff_x + (saucer.dx * Zyklus)), (int)(-diff_y + (saucer.dy * Zyklus))), Winkel(SYNC.get_ship_dx(SyncBR), SYNC.get_ship_dy(SyncBR)));
                    Abweichung_Z = (int)Math.Ceiling(Zyklus * 8) + 2;

                    if (Math.Abs(Abweichung_W) < 5)
                    {
                        saucer.danger = (int)(1000 + Z + Abweichung_Z);
                        saucer.ZDrehung = Z;
                        saucer.ZSumme = (int)(Z + Abweichung_Z);
                        if (Z > 5) saucer.ForceRechts = true;
                        break;
                    }

                    SyncBL--;
                    SyncBR++;

                    if (SyncBL < 0) SyncBL = 255;
                    if (SyncBR > 255) SyncBR = 0;
                }
            }
        }    

        public int ZielAsteroidSF(int Ziel)
        {
            if ((Ziel >= 0) && (Ziel < 99)) return asteroids[Ziel].sf; else return -1;
        }

        public int SchüsseFrei(int inZyklen)
        {
            int anz=0;

            for (int i = 0; i < nshots; i++)
            {
                if ((shots[i].eigen==1)&&((shots[i].ZielZ>inZyklen)||((72-shots[i].Zyklus)>inZyklen))) anz++;
            }

            // Console.SetCursorPosition(90, 40); Console.WriteLine("SF: "+(4-anz).ToString("0"));

            return 4-anz;
        }
    }

    public class FramePacket
    {
        public byte[] vectorram = new byte[1026];
        public UInt16[] vectorram2 = new UInt16[513];
        public char frameno;  // wird bei jedem Frame inkrementiert
        public char ping;     // Der Server schickt das letzte empfangene ping-Byte zurück

        public static FramePacket FromByteArray(byte[] array)
        {
            FramePacket np = new FramePacket();

            if ((array.Length) > 1025)
            {
                for (int i = 0; i < 513; i++)
                {
                    // Damit ich später nicht über einen Pointer auf das Vector-Ram zugreifen
                    // muss, kopiere ich die Daten in ein ushort Array um.
                    np.vectorram2[i] = (ushort)(array[2 * i] + array[(2 * i) + 1] * 256);
                    np.vectorram[i] = array[i];
                }

                np.frameno = (char)array[1024];
                np.ping = (char)array[1025];
            }

            if ((array.Length > 0)&&(array.Length<1025))
            {
                for (int i = 0; i < 513; i++)           // Löschen
                {
                    np.vectorram2[i] = 0; 
                    np.vectorram[i] = 0;
                    np.frameno = (char)0;
                    np.ping = (char)0;
                }

                for (int i = 0; i < array.Length; i++)  // Füllen
                {
                    np.vectorram[i] = array[i];
                }
            }

            return np;
        }
    }

    public class KeysPacket
    {
        const int KEY_HYPERSPACE = 1;
        const int KEY_FIRE = 2;
        const int KEY_THRUST = 4;
        const int KEY_RIGHT = 8;
        const int KEY_LEFT = 16;
        const int KEY_START = 32;
        public int keys;

        public char ping;     // wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.

        public KeysPacket()
        {
            keys = '@';
            ping = (char)0;
        }

        public byte[] ToByteArray()
        {
            byte[] byts = new byte[8];

            byts[0] = (byte)'c';
            byts[1] = (byte)'t';
            byts[2] = (byte)'m';
            byts[3] = (byte)'a';
            byts[4] = (byte)'m';
            byts[5] = (byte)'e';
            byts[6] = (byte)keys;
            byts[7] = (byte)ping;

            return byts;
        }

        public byte[] ToByteArrayName()
        {
            byte[] byts = new byte[38];

            byts[0] = (byte)'c';
            byts[1] = (byte)'t';
            byts[2] = (byte)'n';
            byts[3] = (byte)'a';
            byts[4] = (byte)'m';
            byts[5] = (byte)'e';
            byts[6] = (byte)'M';
            byts[7] = (byte)'a';
            byts[8] = (byte)'d';
            byts[9] = (byte)' ';
            byts[10] = (byte)'M';
            byts[11] = (byte)'a';
            byts[12] = (byte)'x';

            for (int x = 13; x < 38; x++) byts[x] = 0;

            return byts;
        }


        public void clear()
        {
            keys = '@';
        }

        public void hyperspace(bool b)
        {
            if (b)
                keys |= KEY_HYPERSPACE;
            else
                keys &= ~KEY_HYPERSPACE;
        }

        public void fire(bool b)
        {
            if (b)
                keys |= KEY_FIRE;
            else
                keys &= ~KEY_FIRE;
        }

        public void thrust(bool b)
        {
            if (b)
                keys |= KEY_THRUST;
            else
                keys &= ~KEY_THRUST;
        }

        public void left(bool b)
        {
            if (b)
            {
                keys |= KEY_LEFT;
                right(false);
            }
            else
                keys &= ~KEY_LEFT;
        }

        public void right(bool b)
        {
            if (b)
            {
                keys |= KEY_RIGHT;
                left(false);
            }
            else
                keys &= ~KEY_RIGHT;
        }

        public void Start(bool b)
        {
            if (b)
            {
                keys |= KEY_START;
                left(false);
            }
            else
                keys &= ~KEY_START;
        }

    }
}
